/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules.operators;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.operators.AbstractCondition;

@XStreamAlias(value="RX")
public class ConditionRX
extends AbstractCondition
implements Condition {
    private static final long serialVersionUID = 6247657062073419253L;

    public ConditionRX(String var, String exp) throws SyntaxException {
        super(var, exp);
        try {
            Pattern.compile(exp);
        }
        catch (Exception e) {
            throw new SyntaxException("Invalid regular-expression specified: " + exp);
        }
    }

    @Override
    public String getOperator() {
        return Operator.RX.toString();
    }

    @Override
    public boolean matches(String p, String input) {
        Pattern pattern = Pattern.compile(p);
        log.debug("Checking value '" + input + "' against pattern '" + this.getValue() + "'");
        Matcher m = pattern.matcher(input);
        return m.matches();
    }
}

