/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.filter.BooleanOperator;
import org.jwall.web.audit.filter.FilterCompiler;
import org.jwall.web.audit.filter.FilterExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterExpressionList
implements FilterExpression {
    private static final long serialVersionUID = -6592861898522001021L;
    static Logger log = LoggerFactory.getLogger(FilterExpressionList.class);
    BooleanOperator op;
    Collection<FilterExpression> exps;

    public FilterExpressionList(BooleanOperator op, Collection<FilterExpression> exps) {
        this.op = op;
        this.exps = exps;
    }

    public FilterExpressionList(BooleanOperator op, List<AuditEventMatch> matches) {
        this.op = op;
        this.exps = new LinkedList<FilterExpression>();
        for (AuditEventMatch m : matches) {
            this.exps.add(m);
        }
    }

    public FilterExpressionList(AuditEventFilter filter) {
        this(BooleanOperator.AND, (Collection<FilterExpression>)new LinkedList<FilterExpression>());
        for (AuditEventMatch m : filter.getMatches()) {
            this.exps.add(m);
        }
    }

    public BooleanOperator getOperator() {
        return this.op;
    }

    @Override
    public boolean matches(AuditEvent evt) {
        switch (this.op) {
            case OR: {
                return this.or(evt);
            }
        }
        return this.and(evt);
    }

    private boolean and(AuditEvent evt) {
        log.debug("Asserting all matches!");
        for (FilterExpression exp : this.exps) {
            if (exp.matches(evt)) continue;
            return false;
        }
        return true;
    }

    private boolean or(AuditEvent evt) {
        log.debug("Asserting any match!");
        for (FilterExpression exp : this.exps) {
            if (!exp.matches(evt)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.exps.size();
    }

    public Collection<FilterExpression> getElements() {
        return this.exps;
    }

    public FilterExpression getFirst() {
        if (this.exps.isEmpty()) {
            return null;
        }
        return this.exps.iterator().next();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        if (this.exps.size() > 1) {
            s.append("{");
        }
        for (FilterExpression e : this.exps) {
            if (s.length() > 2) {
                s.append("  " + (Object)((Object)this.op) + "  ");
            }
            s.append(FilterCompiler.toFilterString(e));
        }
        if (this.exps.size() > 1) {
            s.append(" }");
        }
        return s.toString();
    }
}

