/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.AuditEventSource;
import org.jwall.web.audit.io.ParseException;

public class AuditEventQueue
implements AuditEventSource,
AuditEventReader,
AuditEventListener {
    AuditEventFilter filter = null;
    Queue<AuditEvent> events = new LinkedBlockingQueue<AuditEvent>();
    protected long polled = 0L;

    public AuditEventQueue() {
    }

    public AuditEventQueue(Collection<AuditEvent> evts) {
        this.events.addAll(evts);
    }

    @Override
    public boolean hasNext() {
        return !this.events.isEmpty();
    }

    @Override
    public AuditEvent nextEvent() {
        AuditEvent e = this.events.poll();
        if (e != null) {
            ++this.polled;
        }
        return e;
    }

    @Override
    public void setFilter(AuditEventFilter filter) {
        this.filter = filter;
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        if (evt != null && (this.filter == null || this.filter.matches(evt))) {
            this.events.add(evt);
        }
    }

    public int size() {
        return this.events.size();
    }

    @Override
    public long bytesAvailable() {
        return 0L;
    }

    @Override
    public long bytesRead() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        return this.nextEvent();
    }

    @Override
    public boolean atEOF() {
        return false;
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

