/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.util.Obfuscator;

public class AuditEventObfuscatorChain {
    protected List<Obfuscator> obfuscators = new LinkedList<Obfuscator>();

    public void addObfuscator(Obfuscator ob) {
        this.obfuscators.add(ob);
    }

    public boolean obfuscatesSection(Obfuscator obfuscator, Integer id) {
        return obfuscator.getSections().contains(id);
    }

    public AuditEvent obfuscate(AuditEvent evt) throws IOException {
        String[] sections = evt.getRawData();
        for (int i = 0; i < sections.length; ++i) {
            for (Obfuscator ob : this.obfuscators) {
                if (!this.obfuscatesSection(ob, i)) continue;
                sections[i] = ob.obfuscate(i, sections[i]);
            }
        }
        for (Obfuscator ob : this.obfuscators) {
            ob.done();
        }
        return new ModSecurityAuditEvent(sections, AuditEventType.ModSecurity2);
    }
}

