/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jwall.audit.server.AuditEventStreamHandler;
import org.jwall.web.audit.AuditEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiver
extends Thread {
    static Logger log = LoggerFactory.getLogger(SyslogReceiver.class);
    ServerSocket socket;
    AuditEventListener storage = null;
    List<AuditEventStreamHandler> handlers = new ArrayList<AuditEventStreamHandler>();

    public SyslogReceiver(InetAddress addr, Integer port, Class<?> handlerClass) throws Exception {
        this.socket = new ServerSocket(port, 100, addr);
        log.info("Listening for connections on " + addr.getHostAddress() + ":" + port);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket connection = this.socket.accept();
                    log.info("incoming connection from {}:{}", (Object)connection.getInetAddress().getHostAddress(), (Object)connection.getPort());
                    AuditEventStreamHandler handler = this.createHandler(connection);
                    handler.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuditEventStreamHandler createHandler(Socket connection) throws Exception {
        AuditEventStreamHandler handler = new AuditEventStreamHandler(this, connection, false);
        if (this.storage != null) {
            handler.setEventStore(this.storage);
        }
        List<AuditEventStreamHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerFinished(AuditEventStreamHandler handler) {
        List<AuditEventStreamHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("storage.engine", "database");
        SyslogReceiver r = new SyslogReceiver(InetAddress.getByName("localhost"), 10000, null);
        r.run();
    }
}

