/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.test;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSamplesTest
extends TestCase {
    protected Log logger = LogFactory.getLog(this.getTestClass());
    public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

    protected String getContextPath() {
        return this.getTestClass().getPackage().getName();
    }

    protected abstract void checkSample(File var1) throws Exception;

    public void testSamples() throws Exception {
        File[] sampleFiles;
        this.logger.debug((Object)"Testing samples.");
        int failed = 0;
        for (File sampleFile : sampleFiles = this.getSampleFiles()) {
            this.logger.debug((Object)("Testing sample [" + sampleFile.getName() + "]."));
            try {
                this.checkSample(sampleFile);
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Sample [" + sampleFile.getName() + "] failed the check."), ex);
                ++failed;
            }
            this.logger.debug((Object)("Finished testing sample [" + sampleFile.getName() + "]."));
        }
        this.logger.debug((Object)"Finished testing samples.");
        Assert.assertTrue((String)("Totally [" + failed + "/" + sampleFiles.length + "] failed the check."), (failed == 0 ? 1 : 0) != 0);
    }

    protected File getBaseDir() {
        try {
            return new File(this.getTestClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected Class<? extends Object> getTestClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected File getSamplesDirectory() {
        return new File(this.getBaseDir(), this.getSamplesDirectoryName());
    }

    protected String getSamplesDirectoryName() {
        return DEFAULT_SAMPLES_DIRECTORY_NAME;
    }

    protected File[] getSampleFiles() {
        File samplesDirectory = this.getSamplesDirectory();
        this.logger.debug((Object)("Sample directory [" + samplesDirectory.getAbsolutePath() + "]."));
        Collection files = FileUtils.listFiles((File)samplesDirectory, (String[])new String[]{"xml"}, (boolean)true);
        return files.toArray(new File[files.size()]);
    }

    protected ClassLoader getContextClassLoader() {
        return this.getTestClass().getClassLoader();
    }

    protected Map<String, ?> getContextProperties() {
        return null;
    }

    public JAXBContext createContext() throws JAXBException {
        String contextPath = this.getContextPath();
        ClassLoader classLoader = this.getContextClassLoader();
        Map<String, ?> properties = this.getContextProperties();
        if (classLoader == null) {
            return JAXBContext.newInstance((String)contextPath);
        }
        if (properties == null) {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
        }
        return JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, properties);
    }
}

