/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.annox.util.StringUtils;
import org.jvnet.jaxb.annox.util.Validate;
import org.jvnet.jaxb.plugin.annotate.AnnotatePlugin;
import org.jvnet.jaxb.plugin.removeannotation.RemoveAnnotationPlugin;
import org.jvnet.jaxb.util.FieldAccessorUtils;
import org.jvnet.jaxb.util.OutlineUtils;
import org.w3c.dom.Element;

public enum AnnotationTarget {
    PACKAGE("package", new QName[]{AnnotatePlugin.ANNOTATE_PACKAGE_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_PACKAGE_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            return fieldOutline.parent().ref._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return classOutline.ref._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return elementOutline.implClass._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            CEnumLeafInfo enclosingClass = enumConstantOutline.target.getEnclosingClass();
            return this.getAnnotatable(outline, outline.getEnum(enclosingClass));
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumOutline.clazz._package();
        }
    }
    ,
    CLASS("class", new QName[]{AnnotatePlugin.ANNOTATE_CLASS_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_CLASS_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            return fieldOutline.parent().ref;
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return classOutline.ref;
        }
    }
    ,
    PROPERTY_GETTER("getter", new QName[]{AnnotatePlugin.ANNOTATE_PROPERTY_GETTER_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_PROPERTY_GETTER_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
            if (_getter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the getter of the field outline [{0}], getter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _getter;
        }
    }
    ,
    PROPERTY_SETTER("setter", new QName[]{AnnotatePlugin.ANNOTATE_PROPERTY_SETTER_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_PROPERTY_SETTER_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
            if (_setter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _setter;
        }
    }
    ,
    PROPERTY_FIELD("field", new QName[]{AnnotatePlugin.ANNOTATE_PROPERTY_FIELD_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_PROPERTY_FIELD_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JFieldVar _field = FieldAccessorUtils.field((FieldOutline)fieldOutline);
            if (_field == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the field of the field outline [{0}] since it could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _field;
        }
    }
    ,
    PROPERTY_SETTER_PARAMETER("setter-parameter", new QName[]{AnnotatePlugin.ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
            if (_setter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            JVar[] params = _setter.listParams();
            if (params.length != 1) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method must have a single parameter(this setter has {1}).", OutlineUtils.getFieldName((FieldOutline)fieldOutline), params.length));
            }
            return params[0];
        }
    }
    ,
    ENUM("enum", new QName[]{AnnotatePlugin.ANNOTATE_ENUM_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_ENUM_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            CEnumLeafInfo enclosingClass = enumConstantOutline.target.getEnclosingClass();
            return this.getAnnotatable(outline, outline.getEnum(enclosingClass));
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumOutline.clazz;
        }
    }
    ,
    ENUM_CONSTANT("enum-constant", new QName[]{AnnotatePlugin.ANNOTATE_ENUM_CONSTANT_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_ENUM_CONSTANT_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumConstantOutline.constRef;
        }
    }
    ,
    ENUM_VALUE_METHOD("enum-value-method", new QName[]{AnnotatePlugin.ANNOTATE_ENUM_VALUE_METHOD_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_ENUM_VALUE_METHOD_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            JMethod valueMethod = enumOutline.clazz.getMethod("value", new JType[0]);
            if (null == valueMethod) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the value() method of the enum [{0}] since it could not be found.", enumOutline.clazz.name()));
            }
            return valueMethod;
        }
    }
    ,
    ENUM_FROM_VALUE_METHOD("enum-fromValue-method", new QName[]{AnnotatePlugin.ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            JCodeModel codeModel = enumOutline.clazz.owner();
            JType jTypeString = codeModel._ref(String.class);
            JMethod fromValueMethod = enumOutline.clazz.getMethod("fromValue", new JType[]{jTypeString});
            if (null == fromValueMethod) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the fromValue(String) method of the enum [{0}] since it could not be found.", enumOutline.clazz.name()));
            }
            return fromValueMethod;
        }
    }
    ,
    ELEMENT("element", new QName[]{AnnotatePlugin.ANNOTATE_ELEMENT_QNAME, AnnotatePlugin.LEGACY_ANNOTATE_ELEMENT_QNAME}){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return elementOutline.implClass;
        }
    };

    private final String target;
    private final Set<QName> names;

    private AnnotationTarget(String target, QName ... names) {
        this.target = target;
        this.names = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(names)));
    }

    public Set<QName> getNames() {
        return this.names;
    }

    public String getTarget() {
        return this.target;
    }

    public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an enum.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an enum constant.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to a class.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to a field.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an element.", this.getTarget()));
    }

    public static AnnotationTarget getAnnotationTarget(Element element, AnnotationTarget defaultAnnotationTarget) {
        Validate.notNull((Object)element);
        Validate.notNull((Object)((Object)defaultAnnotationTarget));
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        if (AnnotatePlugin.ANNOTATE_QNAME.equals(name) || AnnotatePlugin.ANNOTATE_PROPERTY_QNAME.equals(name) || RemoveAnnotationPlugin.REMOVE_ANNOTATION_QNAME.equals(name) || RemoveAnnotationPlugin.REMOVE_ANNOTATION_FROM_PROPERTY_QNAME.equals(name)) {
            String target = element.getAttribute("target");
            if (StringUtils.isEmpty((String)target)) {
                return defaultAnnotationTarget;
            }
            return AnnotationTarget.getAnnotationTarget(target);
        }
        if (AnnotatePlugin.LEGACY_ANNOTATE_QNAME.equals(name) || AnnotatePlugin.LEGACY_ANNOTATE_PROPERTY_QNAME.equals(name) || RemoveAnnotationPlugin.LEGACY_REMOVE_ANNOTATION_QNAME.equals(name) || RemoveAnnotationPlugin.LEGACY_REMOVE_ANNOTATION_FROM_PROPERTY_QNAME.equals(name)) {
            String target = element.getAttribute("target");
            if (target == null || "".equals(target)) {
                return defaultAnnotationTarget;
            }
            return AnnotationTarget.getAnnotationTarget(target);
        }
        for (AnnotationTarget possibleAnnotationTarget : AnnotationTarget.values()) {
            if (!possibleAnnotationTarget.names.contains(name)) continue;
            return possibleAnnotationTarget;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown annotation element name [{0}].", name));
    }

    public static AnnotationTarget getAnnotationTarget(String target) {
        for (AnnotationTarget possibleAnnotationTarget : AnnotationTarget.values()) {
            if (!possibleAnnotationTarget.getTarget().equals(target)) continue;
            return possibleAnnotationTarget;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown annotation target [{0}].", target));
    }
}

