/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.parser.XAnnotationParser;
import org.jvnet.jaxb.annox.util.StringUtils;
import org.jvnet.jaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb.plugin.AnnotationTarget;
import org.jvnet.jaxb.plugin.annotate.Annotator;
import org.jvnet.jaxb.plugin.removeannotation.RemoveAnnotationPlugin;
import org.jvnet.jaxb.util.CustomizationUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AnnotatePlugin
extends AbstractParameterizablePlugin {
    public static final QName ANNOTATE_PROPERTY_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateProperty");
    public static final QName ANNOTATE_PROPERTY_GETTER_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotatePropertyGetter");
    public static final QName ANNOTATE_PROPERTY_SETTER_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotatePropertySetter");
    public static final QName ANNOTATE_PROPERTY_FIELD_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotatePropertyField");
    public static final QName ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotatePropertySetterParameter");
    public static final QName ANNOTATE_PACKAGE_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotatePackage");
    public static final QName ANNOTATE_CLASS_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateClass");
    public static final QName ANNOTATE_ELEMENT_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateElement");
    public static final QName ANNOTATE_ENUM_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateEnum");
    public static final QName ANNOTATE_ENUM_CONSTANT_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateEnumConstant");
    public static final QName ANNOTATE_ENUM_VALUE_METHOD_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateEnumValueMethod");
    public static final QName ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotateEnumFromValueMethod");
    public static final QName ANNOTATE_QNAME = new QName("urn:jaxb.jvnet.org:annox", "annotate");
    public static final QName LEGACY_ANNOTATE_PROPERTY_QNAME = new QName("http://annox.dev.java.net", "annotateProperty");
    public static final QName LEGACY_ANNOTATE_PROPERTY_GETTER_QNAME = new QName("http://annox.dev.java.net", "annotatePropertyGetter");
    public static final QName LEGACY_ANNOTATE_PROPERTY_SETTER_QNAME = new QName("http://annox.dev.java.net", "annotatePropertySetter");
    public static final QName LEGACY_ANNOTATE_PROPERTY_FIELD_QNAME = new QName("http://annox.dev.java.net", "annotatePropertyField");
    public static final QName LEGACY_ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME = new QName("http://annox.dev.java.net", "annotatePropertySetterParameter");
    public static final QName LEGACY_ANNOTATE_PACKAGE_QNAME = new QName("http://annox.dev.java.net", "annotatePackage");
    public static final QName LEGACY_ANNOTATE_CLASS_QNAME = new QName("http://annox.dev.java.net", "annotateClass");
    public static final QName LEGACY_ANNOTATE_ELEMENT_QNAME = new QName("http://annox.dev.java.net", "annotateElement");
    public static final QName LEGACY_ANNOTATE_ENUM_QNAME = new QName("http://annox.dev.java.net", "annotateEnum");
    public static final QName LEGACY_ANNOTATE_ENUM_CONSTANT_QNAME = new QName("http://annox.dev.java.net", "annotateEnumConstant");
    public static final QName LEGACY_ANNOTATE_ENUM_VALUE_METHOD_QNAME = new QName("http://annox.dev.java.net", "annotateEnumValueMethod");
    public static final QName LEGACY_ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME = new QName("http://annox.dev.java.net", "annotateEnumFromValueMethod");
    public static final QName LEGACY_ANNOTATE_QNAME = new QName("http://annox.dev.java.net", "annotate");
    public static final Set<QName> CUSTOMIZATION_ELEMENT_QNAMES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(ANNOTATE_QNAME, ANNOTATE_PACKAGE_QNAME, ANNOTATE_CLASS_QNAME, ANNOTATE_ELEMENT_QNAME, ANNOTATE_PROPERTY_QNAME, ANNOTATE_PROPERTY_FIELD_QNAME, ANNOTATE_PROPERTY_GETTER_QNAME, ANNOTATE_PROPERTY_SETTER_QNAME, ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME, ANNOTATE_ENUM_QNAME, ANNOTATE_ENUM_CONSTANT_QNAME, ANNOTATE_ENUM_VALUE_METHOD_QNAME, ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME, LEGACY_ANNOTATE_QNAME, LEGACY_ANNOTATE_PACKAGE_QNAME, LEGACY_ANNOTATE_CLASS_QNAME, LEGACY_ANNOTATE_ELEMENT_QNAME, LEGACY_ANNOTATE_PROPERTY_QNAME, LEGACY_ANNOTATE_PROPERTY_FIELD_QNAME, LEGACY_ANNOTATE_PROPERTY_GETTER_QNAME, LEGACY_ANNOTATE_PROPERTY_SETTER_QNAME, LEGACY_ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME, LEGACY_ANNOTATE_ENUM_QNAME, LEGACY_ANNOTATE_ENUM_CONSTANT_QNAME, LEGACY_ANNOTATE_ENUM_VALUE_METHOD_QNAME, LEGACY_ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME)));
    private String defaultFieldTarget = "getter";
    private XAnnotationParser annotationParser = XAnnotationParser.INSTANCE;
    private Annotator annotator = new Annotator();

    public String getOptionName() {
        return "Xannotate";
    }

    public String getUsage() {
        return "TBD";
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "setter-parameter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    public XAnnotationParser getAnnotationParser() {
        return this.annotationParser;
    }

    public void setAnnotationParser(XAnnotationParser annotationParser) {
        this.annotationParser = annotationParser;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, options, errorHandler);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, options, errorHandler);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, options, errorHandler);
        }
        return true;
    }

    protected void processElementOutline(ElementOutline elementOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ElementOutline)elementOutline);
        this.annotateElementOutline(elementOutline.implClass.owner(), elementOutline, customizations, errorHandler);
    }

    protected void processEnumOutline(EnumOutline enumOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumOutline)enumOutline);
        this.annotateEnumOutline(enumOutline.clazz.owner(), enumOutline, customizations, errorHandler);
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline, options, errorHandler);
        }
    }

    protected void processClassOutline(ClassOutline classOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.annotateClassOutline(classOutline.ref.owner(), classOutline, customizations, errorHandler);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline, options, errorHandler);
        }
    }

    protected void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.annotateFieldOutline(fieldOutline.parent().ref.owner(), fieldOutline, customizations, errorHandler);
    }

    protected void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumConstantOutline)enumConstantOutline);
        this.annotateEnumConstantOutline(enumOutline.parent().getCodeModel(), enumOutline.parent(), enumConstantOutline, customizations, errorHandler);
    }

    protected void annotateElementOutline(JCodeModel codeModel, ElementOutline elementOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ELEMENT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(elementOutline.parent(), elementOutline);
                this.annotate(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void annotateEnumOutline(JCodeModel codeModel, EnumOutline enumOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutline.parent(), enumOutline);
                this.annotate(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void annotateEnumConstantOutline(JCodeModel codeModel, Outline outline, EnumConstantOutline enumConstantOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM_CONSTANT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(outline, enumConstantOutline);
                this.annotate(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void annotateClassOutline(JCodeModel codeModel, ClassOutline classOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.CLASS);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(classOutline.parent(), classOutline);
                this.annotate(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void annotateFieldOutline(JCodeModel codeModel, FieldOutline fieldOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.getAnnotationTarget(this.getDefaultFieldTarget()));
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(fieldOutline.parent().parent(), fieldOutline);
                this.annotate(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    private void annotate(JCodeModel codeModel, ErrorHandler errorHandler, CPluginCustomization customization, Element element, JAnnotatable annotatable) {
        NodeList elements = element.getChildNodes();
        for (int index = 0; index < elements.getLength(); ++index) {
            String nodeValue;
            XAnnotation annotation;
            Node node = elements.item(index);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                try {
                    annotation = this.getAnnotationParser().parse(child);
                    this.getAnnotator().annotate(codeModel, annotatable, annotation);
                }
                catch (Exception ex) {
                    try {
                        errorHandler.error(new SAXParseException("Error parsing annotation.", customization.locator, ex));
                    }
                    catch (SAXException sAXException) {}
                }
                continue;
            }
            if (node.getNodeType() != 3 || (nodeValue = node.getNodeValue()) == null || StringUtils.isBlank((String)nodeValue)) continue;
            try {
                annotation = this.getAnnotationParser().parse(nodeValue);
                this.getAnnotator().annotate(codeModel, annotatable, annotation);
                continue;
            }
            catch (Exception ex) {
                try {
                    errorHandler.error(new SAXParseException("Error parsing annotation.", customization.locator, ex));
                    continue;
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isCustomizationElementName(QName name) {
        return name != null && ("urn:jaxb.jvnet.org:annox".equals(name.getNamespaceURI()) && !RemoveAnnotationPlugin.CUSTOMIZATION_ELEMENT_QNAMES.contains(name) || "http://annox.dev.java.net".equals(name.getNamespaceURI()) && !RemoveAnnotationPlugin.LEGACY_CUSTOMIZATION_ELEMENT_QNAMES.contains(name));
    }

    public Collection<QName> getCustomizationElementNames() {
        return CUSTOMIZATION_ELEMENT_QNAMES;
    }
}

