/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.model.base;

import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MappedSuperclass;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessPropertyInfos;
import org.jvnet.hyperjaxb3.xjc.model.CClassifier;
import org.jvnet.hyperjaxb3.xjc.model.CClassifyingVisitor;
import org.jvnet.jaxb.util.CustomizationUtils;

public class DefaultProcessPropertyInfos
implements ProcessPropertyInfos {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Collection<CPropertyInfo> process(ProcessModel context, CClassInfo classInfo) {
        Collection<CPropertyInfo> versionPropertyInfos;
        Collection<CPropertyInfo> idPropertyInfos;
        this.logger.debug((Object)("Processing property infos for class info [" + classInfo.getName() + "]."));
        LinkedList<CPropertyInfo> newPropertyInfos = new LinkedList<CPropertyInfo>();
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.GENERATED_ID_ELEMENT_NAME)) {
            idPropertyInfos = context.getGetIdPropertyInfos().process(context, classInfo);
            if (!idPropertyInfos.isEmpty()) {
                this.logger.error((Object)MessageFormat.format("Class info [{0}] is annotated with hj:generated-id customization, but it already contains id properties. The customization will be ignored.", classInfo.getName()));
            } else {
                newPropertyInfos.addAll(this.createDefaultIdPropertyInfos(context, classInfo));
            }
        } else if (this.isRootClass(context, classInfo) && (idPropertyInfos = context.getGetIdPropertyInfos().process(context, classInfo)).isEmpty()) {
            newPropertyInfos.addAll(this.createDefaultIdPropertyInfos(context, classInfo));
        }
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.GENERATED_VERSION_ELEMENT_NAME)) {
            versionPropertyInfos = context.getGetVersionPropertyInfos().process(context, classInfo);
            if (!versionPropertyInfos.isEmpty()) {
                this.logger.error((Object)MessageFormat.format("Class info [{0}] is annotated with hj:generated-version customization, but it already contains version properties. The customization will be ignored.", classInfo.getName()));
            } else {
                newPropertyInfos.addAll(this.createDefaultVersionPropertyInfos(context, classInfo));
            }
        } else if (this.isRootClass(context, classInfo) && (versionPropertyInfos = context.getGetVersionPropertyInfos().process(context, classInfo)).isEmpty()) {
            newPropertyInfos.addAll(this.createDefaultVersionPropertyInfos(context, classInfo));
        }
        CPropertyInfo[] propertyInfos = classInfo.getProperties().toArray(new CPropertyInfo[classInfo.getProperties().size()]);
        for (CPropertyInfo propertyInfo : propertyInfos) {
            if (context.getIgnoring().isPropertyInfoIgnored(context, propertyInfo)) continue;
            newPropertyInfos.addAll(this.process(context, propertyInfo));
        }
        if (classInfo.declaresAttributeWildcard()) {
            this.logger.error((Object)("Class [" + classInfo.getName() + "] declares an attribute wildcard. This is currently not supported. See issue #46."));
        }
        for (CPropertyInfo newPropertyInfo : newPropertyInfos) {
            if (newPropertyInfo.parent() != null) continue;
            classInfo.addProperty(newPropertyInfo);
        }
        this.logger.debug((Object)("Finished processing property infos for class info [" + classInfo.getName() + "]."));
        return newPropertyInfos;
    }

    @Override
    public Collection<CPropertyInfo> process(ProcessModel context, CPropertyInfo propertyInfo) {
        CClassifyingVisitor<Collection<CPropertyInfo>> classifyingVisitor = new CClassifyingVisitor<Collection<CPropertyInfo>>(context, new PropertyClassifier(context));
        return (Collection)propertyInfo.accept(classifyingVisitor);
    }

    public boolean isRootClass(ProcessModel context, CClassInfo classInfo) {
        boolean notMappedSuperclassAndNotEmbeddable;
        boolean bl = notMappedSuperclassAndNotEmbeddable = !CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME) && !CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.EMBEDDABLE_ELEMENT_NAME);
        if (classInfo.getRefBaseClass() != null) {
            return notMappedSuperclassAndNotEmbeddable && !this.isSelfOrAncestorRootClass(context, classInfo.getRefBaseClass());
        }
        if (classInfo.getBaseClass() != null) {
            return notMappedSuperclassAndNotEmbeddable && !this.isSelfOrAncestorRootClass(context, classInfo.getBaseClass());
        }
        return notMappedSuperclassAndNotEmbeddable;
    }

    public boolean isSelfOrAncestorRootClass(ProcessModel context, CClassInfo classInfo) {
        if (this.isRootClass(context, classInfo)) {
            return true;
        }
        if (classInfo.getRefBaseClass() != null) {
            return this.isSelfOrAncestorRootClass(context, classInfo.getRefBaseClass());
        }
        if (classInfo.getBaseClass() != null) {
            return this.isSelfOrAncestorRootClass(context, classInfo.getBaseClass());
        }
        return !CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME) && !CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.EMBEDDABLE_ELEMENT_NAME);
    }

    public boolean isSelfOrAncestorRootClass(ProcessModel context, CClassRef classRef) {
        String className = classRef.fullName();
        try {
            Class<?> referencedClass = Class.forName(className);
            return this.isSelfOrAncestorRootClass(referencedClass);
        }
        catch (ClassNotFoundException cnfex) {
            this.logger.warn((Object)("Referenced class [" + className + "] could not be found, this may lead to incorrect generation of the identifier fields."));
            return true;
        }
    }

    public boolean isRootClass(Class<?> theClass) {
        boolean notMappedSuperclassAndNotEmbeddable;
        boolean bl = notMappedSuperclassAndNotEmbeddable = theClass.getAnnotation(MappedSuperclass.class) == null && theClass.getAnnotation(Embeddable.class) == null;
        if (theClass.getSuperclass() != null) {
            return notMappedSuperclassAndNotEmbeddable && !this.isSelfOrAncestorRootClass(theClass.getSuperclass());
        }
        return notMappedSuperclassAndNotEmbeddable;
    }

    public boolean isSelfOrAncestorRootClass(Class<?> theClass) {
        if (this.isRootClass(theClass)) {
            return true;
        }
        if (theClass.getSuperclass() != null) {
            return this.isSelfOrAncestorRootClass(theClass.getSuperclass());
        }
        return theClass.getAnnotation(MappedSuperclass.class) == null && theClass.getAnnotation(Embeddable.class) == null;
    }

    public Collection<CPropertyInfo> createDefaultIdPropertyInfos(ProcessModel context, CClassInfo classInfo) {
        return (Collection)context.getCreateDefaultIdPropertyInfos().process(context, classInfo);
    }

    public Collection<CPropertyInfo> createDefaultVersionPropertyInfos(ProcessModel context, CClassInfo classInfo) {
        return context.getCreateDefaultVersionPropertyInfos().process(context, classInfo);
    }

    private class PropertyClassifier
    implements CClassifier<Collection<CPropertyInfo>> {
        private ProcessModel context;

        public PropertyClassifier(ProcessModel context) {
            this.context = context;
        }

        @Override
        public Collection<CPropertyInfo> onSingleBuiltinAttribute(CAttributePropertyInfo attributePropertyInfo) {
            return this.context.getWrapSingleBuiltinAttribute().process(this.context, (CPropertyInfo)attributePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleEnumAttribute(CAttributePropertyInfo attributePropertyInfo) {
            return this.context.getWrapSingleEnumAttribute().process(this.context, (CPropertyInfo)attributePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleOtherAttribute(CAttributePropertyInfo attributePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + attributePropertyInfo.getName(true) + "] is a single other attribute. See issue #56."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionBuiltinAttribute(CAttributePropertyInfo attributePropertyInfo) {
            return this.context.getWrapCollectionBuiltinAttribute().process(this.context, (CPropertyInfo)attributePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionEnumAttribute(CAttributePropertyInfo attributePropertyInfo) {
            return this.context.getWrapCollectionEnumAttribute().process(this.context, (CPropertyInfo)attributePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionOtherAttribute(CAttributePropertyInfo attributePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + attributePropertyInfo.getName(true) + "] is a collection other attribute. See issue #59."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onSingleBuiltinValue(CValuePropertyInfo valuePropertyInfo) {
            return this.context.getWrapSingleBuiltinValue().process(this.context, (CPropertyInfo)valuePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleEnumValue(CValuePropertyInfo valuePropertyInfo) {
            return this.context.getWrapSingleEnumValue().process(this.context, (CPropertyInfo)valuePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleOtherValue(CValuePropertyInfo valuePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + valuePropertyInfo.getName(true) + "] is a single other value. See issue #60."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionBuiltinValue(CValuePropertyInfo valuePropertyInfo) {
            return this.context.getWrapCollectionBuiltinValue().process(this.context, (CPropertyInfo)valuePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionEnumValue(CValuePropertyInfo valuePropertyInfo) {
            return this.context.getWrapCollectionEnumValue().process(this.context, (CPropertyInfo)valuePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionOtherValue(CValuePropertyInfo valuePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + valuePropertyInfo.getName(true) + "] is a collection other value. See issue #63."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onSingleBuiltinElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapSingleBuiltinElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleEnumElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapSingleEnumElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleArrayElement(CElementPropertyInfo elementPropertyInfo) {
            throw new UnsupportedOperationException("Arrays are not supported.");
        }

        @Override
        public Collection<CPropertyInfo> onSingleClassElement(CElementPropertyInfo elementPropertyInfo) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onSingleHeteroElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapSingleHeteroElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionBuiltinElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapCollectionBuiltinElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionEnumElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapCollectionEnumElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionArrayElement(CElementPropertyInfo elementPropertyInfo) {
            throw new UnsupportedOperationException("Arrays are not supported.");
        }

        @Override
        public Collection<CPropertyInfo> onCollectionClassElement(CElementPropertyInfo elementPropertyInfo) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionHeteroElement(CElementPropertyInfo elementPropertyInfo) {
            return this.context.getWrapCollectionHeteroElement().process(this.context, (CPropertyInfo)elementPropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleBuiltinElementReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleBuiltinElementReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleEnumElementReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleEnumElementReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleArrayElementReference(CReferencePropertyInfo referencePropertyInfo) {
            throw new UnsupportedOperationException("Arrays are not supported.");
        }

        @Override
        public Collection<CPropertyInfo> onSingleClassReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleClassReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleWildcardReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleWildcardReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleHeteroReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleHeteroReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleClassElementReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleClassElementReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onSingleSubstitutedElementReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapSingleSubstitutedElementReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionBuiltinElementReference(CReferencePropertyInfo referencePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + referencePropertyInfo.getName(true) + "] is a collection builtin element reference. See issue #67 (http://java.net/jira/browse/HYPERJAXB3-67)."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionEnumElementReference(CReferencePropertyInfo referencePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + referencePropertyInfo.getName(true) + "] is a collection enum element reference. See issue #68 (http://java.net/jira/browse/HYPERJAXB3-68)."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionArrayElementReference(CReferencePropertyInfo referencePropertyInfo) {
            throw new UnsupportedOperationException("Arrays are not supported.");
        }

        @Override
        public Collection<CPropertyInfo> onCollectionClassReference(CReferencePropertyInfo referencePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + referencePropertyInfo.getName(true) + "] is a collection class reference. See issue #70."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionWildcardReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapCollectionWildcardReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionClassElementReference(CReferencePropertyInfo referencePropertyInfo) {
            DefaultProcessPropertyInfos.this.logger.error((Object)("[" + referencePropertyInfo.getName(true) + "] is a collection class element reference. See issue #71."));
            return Collections.emptyList();
        }

        @Override
        public Collection<CPropertyInfo> onCollectionSubstitutedElementReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapCollectionHeteroReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }

        @Override
        public Collection<CPropertyInfo> onCollectionHeteroReference(CReferencePropertyInfo referencePropertyInfo) {
            return this.context.getWrapCollectionHeteroReference().process(this.context, (CPropertyInfo)referencePropertyInfo);
        }
    }
}

