/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.mapping;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.fmt.JTextFile;
import com.sun.java.xml.ns.persistence.orm.Embeddable;
import com.sun.java.xml.ns.persistence.orm.Entity;
import com.sun.java.xml.ns.persistence.orm.EntityMappings;
import com.sun.java.xml.ns.persistence.orm.MappedSuperclass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.plugin.EjbPlugin;
import org.jvnet.hyperjaxb3.ejb.strategy.ignoring.Ignoring;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.ejb.strategy.outline.OutlineProcessor;
import org.jvnet.hyperjaxb3.persistence.jpa1.JPA1Utils;
import org.jvnet.jaxb2_commons.util.CodeModelUtils;
import org.jvnet.jaxb2_commons.util.OutlineUtils;

public class MarshalMappings
implements OutlineProcessor<EjbPlugin> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Ignoring ignoring;
    private Mapping mapping;

    protected Marshaller getMarshaller() throws JAXBException {
        return JPA1Utils.createMarshaller();
    }

    @Override
    public Collection<ClassOutline> process(EjbPlugin context, Outline outline, Options options) throws Exception {
        this.logger.debug((Object)("Processing outline with context path [" + OutlineUtils.getContextPath((Outline)outline) + "]."));
        Collection classes = outline.getClasses();
        ArrayList<ClassOutline> processedClassOutlines = new ArrayList<ClassOutline>(classes.size());
        for (ClassOutline classOutline : classes) {
            ClassOutline processedClassOutline;
            if (this.getIgnoring().isClassOutlineIgnored(this.getMapping(), classOutline) || (processedClassOutline = this.process(this, classOutline, options)) == null) continue;
            processedClassOutlines.add(processedClassOutline);
        }
        return processedClassOutlines;
    }

    public ClassOutline process(MarshalMappings context, ClassOutline classOutline, Options options) throws Exception {
        this.logger.debug((Object)("Processing class outline [" + OutlineUtils.getClassName((ClassOutline)classOutline) + "]."));
        String className = CodeModelUtils.getLocalClassName((JClass)classOutline.ref);
        JTextFile classOrmXmlFile = new JTextFile(className + ".orm.xml");
        classOutline._package()._package().addResourceFile((JResourceFile)classOrmXmlFile);
        EntityMappings entityMappings = this.createEntityMappings();
        Object draftEntityOrMappedSuperclassOrEmbeddable = context.getMapping().getEntityOrMappedSuperclassOrEmbeddableMapping().process(context.getMapping(), classOutline, options);
        if (draftEntityOrMappedSuperclassOrEmbeddable instanceof Entity) {
            Entity draftEntity = (Entity)draftEntityOrMappedSuperclassOrEmbeddable;
            Entity entity = new Entity();
            entity.mergeFrom((Object)draftEntity, (Object)entity);
            entityMappings.getEntity().add(entity);
        } else if (draftEntityOrMappedSuperclassOrEmbeddable instanceof MappedSuperclass) {
            MappedSuperclass draftMappedSuperclass = (MappedSuperclass)draftEntityOrMappedSuperclassOrEmbeddable;
            MappedSuperclass entity = new MappedSuperclass();
            entity.mergeFrom((Object)draftMappedSuperclass, (Object)entity);
            entityMappings.getMappedSuperclass().add(entity);
        } else if (draftEntityOrMappedSuperclassOrEmbeddable instanceof Embeddable) {
            Embeddable draftEmbeddable = (Embeddable)draftEntityOrMappedSuperclassOrEmbeddable;
            Embeddable entity = new Embeddable();
            entity.mergeFrom((Object)draftEmbeddable, (Object)entity);
            entityMappings.getEmbeddable().add(entity);
        } else {
            throw new AssertionError((Object)"Either one-to-many or many-to-many mappings are expected.");
        }
        StringWriter writer = new StringWriter();
        this.getMarshaller().marshal((Object)entityMappings, (Writer)writer);
        classOrmXmlFile.setContents(((Object)writer).toString());
        return classOutline;
    }

    protected EntityMappings createEntityMappings() {
        EntityMappings entityMappings = new EntityMappings();
        entityMappings.setVersion("1.0");
        return entityMappings;
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }
}

