/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import com.google.common.base.Preconditions;
import hudson.model.Hudson;
import hudson.model.Job;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobUuid {
    private static final Logger log = LoggerFactory.getLogger(JobUuid.class);
    private static final Map<Job<?, ?>, UUID> cache = new WeakHashMap();
    public static final String ENCODED_PREFIX = "UU-";
    public static final String ENCODED_SUFFIX = "-ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID get(Job<?, ?> job) {
        UUID id;
        Preconditions.checkNotNull(job);
        Map<Job<?, ?>, UUID> map = cache;
        synchronized (map) {
            id = cache.get(job);
            if (id == null) {
                block15: {
                    File file = new File(job.getRootDir(), "uuid");
                    if (file.exists()) {
                        log.debug("Loading UUID from file: {}", (Object)file);
                        try {
                            BufferedReader reader = new BufferedReader(new FileReader(file));
                            try {
                                String line = reader.readLine();
                                id = UUID.fromString(line);
                                break block15;
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    log.debug("Missing UUID for job: {}; writing new UUID to file: {}", job, (Object)file);
                    file.getParentFile().mkdirs();
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                        try {
                            id = UUID.randomUUID();
                            writer.write(id.toString());
                            writer.flush();
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                cache.put(job, id);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Job<?, ?> find(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        Map<Job<?, ?>, UUID> map = cache;
        synchronized (map) {
            for (Job job : Hudson.getInstance().getAllItems(Job.class)) {
                UUID id = JobUuid.get(job);
                if (id == null || !uuid.equals(id)) continue;
                return job;
            }
        }
        return null;
    }

    public static Job<?, ?> find(String uuid) {
        return JobUuid.find(UUID.fromString(uuid));
    }

    public static String encode(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return String.format("%s%s%s", ENCODED_PREFIX, uuid, ENCODED_SUFFIX);
    }

    public static UUID decode(String spec) {
        Preconditions.checkNotNull((Object)spec);
        if (spec.startsWith(ENCODED_PREFIX) && spec.endsWith(ENCODED_SUFFIX)) {
            String tmp = spec.substring(ENCODED_PREFIX.length(), spec.length() - ENCODED_SUFFIX.length());
            return UUID.fromString(tmp);
        }
        throw new IllegalArgumentException("Non-encoded UUID string: " + spec);
    }
}

