/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import com.google.common.base.Preconditions;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Project;
import hudson.model.TopLevelItem;
import hudson.security.Permission;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.hudsonci.utils.tasks.JobUuid;
import org.hudsonci.utils.tasks.UnsupportedProjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaProject {
    private static final Logger log = LoggerFactory.getLogger(MetaProject.class);
    private final AbstractProject delegate;
    private final Type type;

    public MetaProject(AbstractProject project) {
        this.delegate = (AbstractProject)Preconditions.checkNotNull((Object)project);
        if (this.delegate instanceof MatrixProject) {
            this.type = Type.MULTICONFIG;
        } else if (this.delegate instanceof Project) {
            this.type = Type.NORMAL;
        } else {
            this.type = Type.UNSUPPORTED;
            log.debug("Unsupported project type: {}", (Object)project.getClass().getName());
        }
    }

    public AbstractProject getDelegate() {
        return this.delegate;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isSupported() {
        return this.getType() != Type.UNSUPPORTED;
    }

    public boolean isNormal() {
        return this.getType() == Type.NORMAL;
    }

    public boolean isMultiConfig() {
        return this.getType() == Type.MULTICONFIG;
    }

    public String toString() {
        return String.format("%s (%s,%s)", new Object[]{this.getFullDisplayName(), this.getType(), this.getId()});
    }

    public Project<?, ?> asNormal() {
        return (Project)this.getDelegate();
    }

    public MatrixProject asMultiConfig() {
        return (MatrixProject)this.getDelegate();
    }

    public ItemGroup getParent() {
        return this.getDelegate().getParent();
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public String getFullName() {
        return this.getDelegate().getFullName();
    }

    public String getDisplayName() {
        return this.getDelegate().getDisplayName();
    }

    public String getFullDisplayName() {
        return this.getDelegate().getFullDisplayName();
    }

    public UUID getId() {
        return JobUuid.get(this.getDelegate());
    }

    public void setEnabled(boolean enabled) throws IOException {
        this.getDelegate().makeDisabled(!enabled);
    }

    public boolean isEnabled() {
        return !this.getDelegate().isDisabled();
    }

    public Collection<JobProperty> getProperties() {
        return this.getDelegate().getAllProperties();
    }

    public void addProperty(JobProperty item) throws IOException {
        Preconditions.checkNotNull((Object)item);
        this.getDelegate().addProperty(item);
    }

    public Collection<Trigger> getTriggers() {
        return this.getDelegate().getTriggers().values();
    }

    public void addTrigger(Trigger item) throws IOException {
        Preconditions.checkNotNull((Object)item);
        this.getDelegate().addTrigger(item);
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        switch (this.getType()) {
            case NORMAL: {
                return this.asNormal().getBuildWrappersList();
            }
            case MULTICONFIG: {
                return this.asMultiConfig().getBuildWrappersList();
            }
        }
        throw new UnsupportedProjectException(this.getDelegate());
    }

    public Collection<BuildWrapper> getBuildWrappers() {
        return this.getBuildWrappersList().toList();
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList() {
        switch (this.getType()) {
            case NORMAL: {
                return this.asNormal().getBuildersList();
            }
            case MULTICONFIG: {
                return this.asMultiConfig().getBuildersList();
            }
        }
        throw new UnsupportedProjectException(this.getDelegate());
    }

    public Collection<Builder> getBuilders() {
        return this.getBuildersList().toList();
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        switch (this.getType()) {
            case NORMAL: {
                return this.asNormal().getPublishersList();
            }
            case MULTICONFIG: {
                return this.asMultiConfig().getPublishersList();
            }
        }
        throw new UnsupportedProjectException(this.getDelegate());
    }

    public Collection<Publisher> getPublishers() {
        return this.getPublishersList().toList();
    }

    public void checkPermission(Permission perm) {
        this.getDelegate().checkPermission(perm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetaProject that = (MetaProject)obj;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static Collection<MetaProject> list(Filter filter) {
        ArrayList<MetaProject> projects = new ArrayList<MetaProject>();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            MetaProject project = new MetaProject((AbstractProject)item);
            if (filter != null && !filter.accept(project)) continue;
            projects.add(project);
        }
        return projects;
    }

    public static Collection<MetaProject> list() {
        return MetaProject.list(null);
    }

    public static MetaProject find(UUID id) {
        Preconditions.checkNotNull((Object)id);
        Job<?, ?> job = JobUuid.find(id);
        if (job instanceof AbstractProject) {
            return new MetaProject((AbstractProject)job);
        }
        return null;
    }

    public static MetaProject find(String id) {
        Preconditions.checkNotNull((Object)id);
        return MetaProject.find(UUID.fromString(id));
    }

    public static interface Filter {
        public boolean accept(MetaProject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNSUPPORTED,
        NORMAL,
        MULTICONFIG;

    }
}

