/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.DefaultListener;
import org.junit.support.testng.engine.InvocationDescriptor;
import org.junit.support.testng.engine.MethodDescriptor;
import org.junit.support.testng.engine.TestClassRegistry;
import org.junit.support.testng.engine.TestDescriptorFactory;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.CustomAttribute;

class ExecutionListener
extends DefaultListener {
    private final TestClassRegistry testClassRegistry = new TestClassRegistry();
    private final Map<ITestNGMethod, MethodProgress> inProgressTestMethods = new ConcurrentHashMap<ITestNGMethod, MethodProgress>();
    private final Set<ITestResult> engineLevelFailureResults = ConcurrentHashMap.newKeySet();
    private final Map<ClassDescriptor, Set<ITestResult>> classLevelFailureResults = new ConcurrentHashMap<ClassDescriptor, Set<ITestResult>>();
    private final EngineExecutionListener delegate;
    private final TestNGEngineDescriptor engineDescriptor;

    ExecutionListener(EngineExecutionListener delegate, TestNGEngineDescriptor engineDescriptor) {
        this.delegate = delegate;
        this.engineDescriptor = engineDescriptor;
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        ClassDescriptor classDescriptor = Objects.requireNonNull(this.engineDescriptor.findClassDescriptor(testClass.getRealClass()), "Missing class descriptor");
        this.testClassRegistry.start(testClass.getRealClass(), __ -> {
            this.delegate.executionStarted((TestDescriptor)classDescriptor);
            return classDescriptor;
        });
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        this.handleConfigurationResult(result);
    }

    @Override
    public void onConfigurationSkip(ITestResult result) {
        this.handleConfigurationResult(result);
    }

    private void handleConfigurationResult(ITestResult result) {
        Optional<ClassDescriptor> classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass());
        if (classDescriptor.isPresent()) {
            this.classLevelFailureResults.computeIfAbsent(classDescriptor.get(), __ -> ConcurrentHashMap.newKeySet()).add(result);
        } else {
            this.engineLevelFailureResults.add(result);
        }
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.testClassRegistry.finish(testClass.getRealClass(), classDescriptor -> classDescriptor.remainingIterations.decrementAndGet() == 0, classDescriptor -> {
            this.finishMethodsNotYetReportedAsFinished(testClass);
            Set<ITestResult> results = this.classLevelFailureResults.remove(classDescriptor);
            this.delegate.executionFinished((TestDescriptor)classDescriptor, this.toTestExecutionResult(results));
        });
    }

    @Override
    public void onTestStart(ITestResult result) {
        MethodProgress progress = this.startMethodProgress(result);
        int invocationIndex = progress.invocationIndex.getAndIncrement();
        if (invocationIndex == 0) {
            this.reportStarted(result, progress);
        }
        if (progress.descriptor.getType().isContainer()) {
            try {
                progress.reportedAsStarted.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for test method to be reported as started");
            }
            this.createInvocationAndReportStarted(progress, invocationIndex, result);
        }
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        this.reportFinished(result, TestExecutionResult.successful());
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        MethodProgress progress = this.inProgressTestMethods.get(result.getMethod());
        if (progress != null || result.getThrowable() != null) {
            if (progress == null) {
                this.reportStarted(result, this.startMethodProgress(result));
            }
            this.reportFinished(result, TestExecutionResult.aborted((Throwable)result.getThrowable()));
        } else {
            MethodDescriptor methodDescriptor = this.findOrCreateMethodDescriptor(result);
            this.delegate.executionSkipped((TestDescriptor)methodDescriptor, "<unknown>");
        }
    }

    @Override
    public void onTestFailure(ITestResult result) {
        if (!this.inProgressTestMethods.containsKey(result.getMethod())) {
            this.reportStarted(result, this.startMethodProgress(result));
        }
        this.reportFinished(result, TestExecutionResult.failed((Throwable)result.getThrowable()));
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestSuccess(result);
    }

    @Override
    public void onTestFailedWithTimeout(ITestResult result) {
        this.onTestFailure(result);
    }

    private MethodProgress startMethodProgress(ITestResult result) {
        MethodDescriptor methodDescriptor = this.findOrCreateMethodDescriptor(result);
        return this.inProgressTestMethods.computeIfAbsent(result.getMethod(), __ -> new MethodProgress(result.getMethod(), methodDescriptor));
    }

    private void finishMethodsNotYetReportedAsFinished(ITestClass testClass) {
        for (ITestNGMethod testMethod : testClass.getTestMethods()) {
            MethodProgress progress = this.inProgressTestMethods.remove(testMethod);
            if (progress == null) continue;
            this.delegate.executionFinished((TestDescriptor)progress.descriptor, TestExecutionResult.successful());
        }
    }

    private void reportStarted(ITestResult result, MethodProgress progress) {
        Map<String, String> attributes;
        this.delegate.executionStarted((TestDescriptor)progress.descriptor);
        progress.reportedAsStarted.countDown();
        String description = result.getMethod().getDescription();
        if (description != null && !description.trim().isEmpty()) {
            this.delegate.reportingEntryPublished((TestDescriptor)progress.descriptor, ReportEntry.from((String)"description", (String)description.trim()));
        }
        if (!(attributes = this.getAttributes(result)).isEmpty()) {
            this.delegate.reportingEntryPublished((TestDescriptor)progress.descriptor, ReportEntry.from(attributes));
        }
    }

    private void reportFinished(ITestResult result, TestExecutionResult executionResult) {
        MethodProgress progress = this.inProgressTestMethods.get(result.getMethod());
        if (progress.descriptor.getType().isContainer() && progress.invocations.containsKey(result)) {
            InvocationDescriptor invocationDescriptor = (InvocationDescriptor)((Object)progress.invocations.remove(result));
            this.delegate.executionFinished((TestDescriptor)invocationDescriptor, executionResult);
        } else {
            this.inProgressTestMethods.remove(result.getMethod());
            this.delegate.executionFinished((TestDescriptor)progress.descriptor, executionResult);
        }
    }

    private MethodDescriptor findOrCreateMethodDescriptor(ITestResult result) {
        ClassDescriptor classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass()).orElseThrow(() -> new IllegalStateException("Missing class descriptor for " + result.getTestClass()));
        Optional<MethodDescriptor> methodDescriptor = classDescriptor.findMethodDescriptor(result);
        if (methodDescriptor.isPresent()) {
            return methodDescriptor.get();
        }
        MethodDescriptor dynamicMethodDescriptor = this.getTestDescriptorFactory().createMethodDescriptor(classDescriptor, result);
        classDescriptor.addChild((TestDescriptor)dynamicMethodDescriptor);
        this.delegate.dynamicTestRegistered((TestDescriptor)dynamicMethodDescriptor);
        return dynamicMethodDescriptor;
    }

    private void createInvocationAndReportStarted(MethodProgress progress, int invocationIndex, ITestResult result) {
        InvocationDescriptor invocationDescriptor = this.getTestDescriptorFactory().createInvocationDescriptor(progress.descriptor, result, invocationIndex);
        progress.invocations.put(result, invocationDescriptor);
        progress.descriptor.addChild((TestDescriptor)invocationDescriptor);
        this.delegate.dynamicTestRegistered((TestDescriptor)invocationDescriptor);
        this.delegate.executionStarted((TestDescriptor)invocationDescriptor);
    }

    private TestDescriptorFactory getTestDescriptorFactory() {
        return this.engineDescriptor.getTestDescriptorFactory();
    }

    public TestExecutionResult toEngineResult() {
        return this.toTestExecutionResult(this.engineLevelFailureResults);
    }

    private TestExecutionResult toTestExecutionResult(Set<ITestResult> results) {
        return results == null || results.isEmpty() ? TestExecutionResult.successful() : ExecutionListener.abortedOrFailed(results);
    }

    private static TestExecutionResult abortedOrFailed(Set<ITestResult> results) {
        return results.stream().allMatch(it -> it.getStatus() == 3) ? TestExecutionResult.aborted((Throwable)ExecutionListener.chain(ExecutionListener.throwables(results))) : TestExecutionResult.failed((Throwable)ExecutionListener.chain(ExecutionListener.throwables(results)));
    }

    private static Stream<Throwable> throwables(Set<ITestResult> results) {
        return results.stream().map(ITestResult::getThrowable).filter(Objects::nonNull);
    }

    private static Throwable chain(Stream<Throwable> failures) {
        Iterator iterator = failures.iterator();
        Throwable throwable = (Throwable)iterator.next();
        iterator.forEachRemaining(throwable::addSuppressed);
        return throwable;
    }

    private Map<String, String> getAttributes(ITestResult result) {
        try {
            CustomAttribute[] attributes = result.getMethod().getAttributes();
            if (attributes.length > 0) {
                return Arrays.stream(attributes).collect(Collectors.toMap(CustomAttribute::name, attr -> String.join((CharSequence)", ", attr.values())));
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    static class MethodProgress {
        final ITestNGMethod method;
        final MethodDescriptor descriptor;
        final ConcurrentMap<ITestResult, InvocationDescriptor> invocations = new ConcurrentHashMap<ITestResult, InvocationDescriptor>();
        final AtomicInteger invocationIndex = new AtomicInteger();
        final CountDownLatch reportedAsStarted = new CountDownLatch(1);

        public MethodProgress(ITestNGMethod method, MethodDescriptor descriptor) {
            this.method = method;
            this.descriptor = descriptor;
        }
    }
}

