/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.junit.gen5.api.extension.Extension;
import org.junit.gen5.api.extension.ExtensionPoint;
import org.junit.gen5.api.extension.ExtensionPointRegistry;
import org.junit.gen5.api.extension.ExtensionRegistrar;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.junit5.extension.DisabledCondition;
import org.junit.gen5.engine.junit5.extension.ExtensionPointSorter;
import org.junit.gen5.engine.junit5.extension.RegisteredExtensionPoint;
import org.junit.gen5.engine.junit5.extension.TestInfoParameterResolver;
import org.junit.gen5.engine.junit5.extension.TestReporterParameterResolver;

@API(value=API.Usage.Internal)
public class ExtensionRegistry {
    private static final Logger LOG = Logger.getLogger(ExtensionRegistry.class.getName());
    private static final List<Class<? extends Extension>> defaultExtensionTypes = Collections.unmodifiableList(Arrays.asList(DisabledCondition.class, TestInfoParameterResolver.class, TestReporterParameterResolver.class));
    private final Set<Class<? extends Extension>> registeredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>();
    private final List<RegisteredExtensionPoint<?>> registeredExtensionPoints = new ArrayList();
    private final Optional<ExtensionRegistry> parent;

    public static ExtensionRegistry newRegistryFrom(ExtensionRegistry parentRegistry, List<Class<? extends Extension>> extensionTypes) {
        ExtensionRegistry newExtensionRegistry = new ExtensionRegistry(parentRegistry);
        extensionTypes.forEach(newExtensionRegistry::registerExtension);
        return newExtensionRegistry;
    }

    static List<Class<? extends Extension>> getDefaultExtensionTypes() {
        return defaultExtensionTypes;
    }

    public ExtensionRegistry() {
        this(null);
    }

    ExtensionRegistry(ExtensionRegistry parent) {
        this.parent = Optional.ofNullable(parent);
        if (!this.parent.isPresent()) {
            this.addDefaultExtensions();
        }
    }

    private void addDefaultExtensions() {
        ExtensionRegistry.getDefaultExtensionTypes().stream().forEach(this::registerExtension);
    }

    Set<Class<? extends Extension>> getRegisteredExtensionTypes() {
        LinkedHashSet<Class<? extends Extension>> allRegisteredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>();
        this.parent.ifPresent(parentRegistry -> allRegisteredExtensionTypes.addAll(parentRegistry.getRegisteredExtensionTypes()));
        allRegisteredExtensionTypes.addAll(this.registeredExtensionTypes);
        return Collections.unmodifiableSet(allRegisteredExtensionTypes);
    }

    private <E extends ExtensionPoint> List<RegisteredExtensionPoint<E>> getRegisteredExtensionPoints(Class<E> extensionType) {
        ArrayList allExtensionPoints = new ArrayList();
        this.parent.ifPresent(parentRegistry -> allExtensionPoints.addAll(parentRegistry.getRegisteredExtensionPoints(extensionType)));
        this.registeredExtensionPoints.stream().filter(registeredExtensionPoint -> extensionType.isAssignableFrom(registeredExtensionPoint.getExtensionPoint().getClass())).forEach(extensionPoint -> allExtensionPoints.add((RegisteredExtensionPoint)extensionPoint));
        return allExtensionPoints;
    }

    public <E extends ExtensionPoint> Stream<RegisteredExtensionPoint<E>> stream(Class<E> extensionPointType, ApplicationOrder order) {
        List registeredExtensionPoints = this.getRegisteredExtensionPoints(extensionPointType);
        new ExtensionPointSorter().sort(registeredExtensionPoints);
        if (order == ApplicationOrder.BACKWARD) {
            Collections.reverse(registeredExtensionPoints);
        }
        return registeredExtensionPoints.stream();
    }

    void registerExtension(Class<? extends Extension> extensionType) {
        boolean extensionAlreadyRegistered = this.getRegisteredExtensionTypes().stream().anyMatch(registeredType -> registeredType.equals(extensionType));
        if (!extensionAlreadyRegistered) {
            Extension extension = (Extension)ReflectionUtils.newInstance(extensionType, (Object[])new Object[0]);
            this.registerExtensionPoint(extension);
            this.registerExtensionPointsFromRegistrar(extension);
            this.registeredExtensionTypes.add(extensionType);
        }
    }

    private void registerExtensionPoint(Extension extension) {
        if (extension instanceof ExtensionPoint) {
            this.registerExtensionPoint((ExtensionPoint)extension, extension);
        }
    }

    public void registerExtensionPoint(ExtensionPoint extension, Object source) {
        this.registerExtensionPoint(extension, source, ExtensionPointRegistry.Position.DEFAULT);
    }

    private void registerExtensionPoint(ExtensionPoint extension, Object source, ExtensionPointRegistry.Position position) {
        LOG.finer(() -> String.format("Registering extension point [%s] from source [%s] with position [%s].", extension, source, position));
        this.registeredExtensionPoints.add(new RegisteredExtensionPoint<ExtensionPoint>(extension, source, position));
    }

    private void registerExtensionPointsFromRegistrar(Extension extension) {
        if (extension instanceof ExtensionRegistrar) {
            ExtensionRegistrar extensionRegistrar = (ExtensionRegistrar)extension;
            extensionRegistrar.registerExtensions((ExtensionPointRegistry)new DelegatingExtensionPointRegistry(extensionRegistrar));
        }
    }

    private class DelegatingExtensionPointRegistry
    implements ExtensionPointRegistry {
        private final ExtensionRegistrar extensionRegistrar;

        DelegatingExtensionPointRegistry(ExtensionRegistrar extensionRegistrar) {
            this.extensionRegistrar = extensionRegistrar;
        }

        public void register(ExtensionPoint extensionPoint, ExtensionPointRegistry.Position position) {
            ExtensionRegistry.this.registerExtensionPoint(extensionPoint, this.extensionRegistrar, position);
        }
    }

    public static enum ApplicationOrder {
        FORWARD,
        BACKWARD;

    }
}

