/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.discovery;

import java.util.function.Predicate;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.junit5.discovery.IsNestedTestClass;
import org.junit.gen5.engine.junit5.discovery.IsPotentialTestContainer;
import org.junit.gen5.engine.junit5.discovery.IsTestMethod;

@API(value=API.Usage.Internal)
public class IsTestClassWithTests
implements Predicate<Class<?>> {
    private static final IsTestMethod isTestMethod = new IsTestMethod();
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();

    @Override
    public boolean test(Class<?> candidate) {
        if (!isPotentialTestContainer.test(candidate)) {
            return false;
        }
        return this.hasTestMethods(candidate) || this.hasNestedTests(candidate);
    }

    private boolean hasTestMethods(Class<?> candidate) {
        return !ReflectionUtils.findMethods(candidate, (Predicate)isTestMethod, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyDown).isEmpty();
    }

    private boolean hasNestedTests(Class<?> candidate) {
        return !ReflectionUtils.findNestedClasses(candidate, (Predicate)isNestedTestClass).isEmpty();
    }
}

