/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.api.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Experimental)
public interface ExtensionContext {
    public Optional<ExtensionContext> getParent();

    public String getUniqueId();

    public String getName();

    public String getDisplayName();

    public Class<?> getTestClass();

    public AnnotatedElement getElement();

    public void publishReportEntry(Map<String, String> var1);

    default public Store getStore() {
        return this.getStore(Namespace.DEFAULT);
    }

    public Store getStore(Namespace var1);

    public static class Namespace {
        public static final Namespace DEFAULT = Namespace.of(new Object());
        private final Set<?> parts;

        public static Namespace of(Object ... parts) {
            Preconditions.notNull((Object[])parts, (String)"There must be at least one reference object to create a namespace");
            return new Namespace(parts);
        }

        private Namespace(Object ... parts) {
            this.parts = new HashSet<Object>(Arrays.asList(parts));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Namespace namespace = (Namespace)o;
            return this.parts.equals(namespace.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }

    public static interface Store {
        public Object get(Object var1);

        public void put(Object var1, Object var2);

        public Object getOrComputeIfAbsent(Object var1, Function<Object, Object> var2);

        public Object remove(Object var1);
    }
}

