/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.DiscoverySelector;
import org.junit.gen5.engine.discovery.ClassSelector;
import org.junit.gen5.engine.discovery.MethodSelector;
import org.junit.gen5.engine.discovery.PackageSelector;

@API(value=API.Usage.Experimental)
public class NameBasedSelector {
    public static DiscoverySelector forName(String name) {
        Optional testClassOptional = ReflectionUtils.loadClass((String)name);
        if (testClassOptional.isPresent()) {
            return ClassSelector.forClass((Class)testClassOptional.get());
        }
        Optional testMethodOptional = ReflectionUtils.loadMethod((String)name);
        if (testMethodOptional.isPresent()) {
            Method testMethod = (Method)testMethodOptional.get();
            return MethodSelector.forMethod(testMethod.getDeclaringClass(), testMethod);
        }
        if (ReflectionUtils.isPackage((String)name)) {
            return PackageSelector.forPackageName(name);
        }
        throw new PreconditionViolationException(String.format("'%s' specifies neither a class, a method, nor a package.", name));
    }

    public static List<DiscoverySelector> forNames(String ... classNames) {
        if (classNames != null) {
            return NameBasedSelector.forNames(Arrays.asList(classNames));
        }
        return Collections.emptyList();
    }

    public static List<DiscoverySelector> forNames(Collection<String> classNames) {
        return classNames.stream().map(NameBasedSelector::forName).collect(Collectors.toList());
    }
}

