/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine;

import java.util.Arrays;
import java.util.Collection;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.CollectionUtils;
import org.junit.gen5.engine.CombinedDiscoveryFilter;
import org.junit.gen5.engine.Filter;

@API(value=API.Usage.Experimental)
public interface DiscoveryFilter<T>
extends Filter<T> {
    @SafeVarargs
    public static <T> DiscoveryFilter<T> combine(DiscoveryFilter<T> ... filters) {
        if (filters == null) {
            return CombinedDiscoveryFilter.alwaysIncluded();
        }
        return DiscoveryFilter.combine(Arrays.asList(filters));
    }

    public static <T> DiscoveryFilter<T> combine(Collection<? extends DiscoveryFilter<T>> filters) {
        if (filters == null || filters.isEmpty()) {
            return CombinedDiscoveryFilter.alwaysIncluded();
        }
        if (filters.size() == 1) {
            return (DiscoveryFilter)CollectionUtils.getOnlyElement(filters);
        }
        return new CombinedDiscoveryFilter(filters);
    }
}

