/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.management;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import javax.cache.management.CacheStatisticsMXBean;
import org.jsr107.ri.RICache;

public class RICacheStatisticsMXBean
implements CacheStatisticsMXBean,
Serializable {
    private static final long serialVersionUID = -5589437411679003894L;
    private static final long NANOSECONDS_IN_A_MICROSECOND = 1000L;
    private transient Cache<?, ?> cache;
    private final AtomicLong cacheRemovals = new AtomicLong();
    private final AtomicLong cacheExpiries = new AtomicLong();
    private final AtomicLong cachePuts = new AtomicLong();
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheEvictions = new AtomicLong();
    private final AtomicLong cachePutTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheGetTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheRemoveTimeTakenNanos = new AtomicLong();

    public RICacheStatisticsMXBean(Cache<?, ?> cache) {
        this.cache = cache;
    }

    public void clear() {
        this.cachePuts.set(0L);
        this.cacheMisses.set(0L);
        this.cacheRemovals.set(0L);
        this.cacheExpiries.set(0L);
        this.cacheHits.set(0L);
        this.cacheEvictions.set(0L);
        this.cacheGetTimeTakenNanos.set(0L);
        this.cachePutTimeTakenNanos.set(0L);
        this.cacheRemoveTimeTakenNanos.set(0L);
    }

    public long getEntryCount() {
        return ((RICache)this.cache).getSize();
    }

    public long getCacheHits() {
        return this.cacheHits.longValue();
    }

    public float getCacheHitPercentage() {
        Long hits = this.getCacheHits();
        if (hits == 0L) {
            return 0.0f;
        }
        return (float)hits.longValue() / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheMisses() {
        return this.cacheMisses.longValue();
    }

    public float getCacheMissPercentage() {
        Long misses = this.getCacheMisses();
        if (misses == 0L) {
            return 0.0f;
        }
        return (float)misses.longValue() / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    public long getCachePuts() {
        return this.cachePuts.longValue();
    }

    public long getCacheRemovals() {
        return this.cacheRemovals.longValue();
    }

    public long getCacheEvictions() {
        return this.cacheEvictions.longValue();
    }

    public float getAverageGetTime() {
        if (this.cacheGetTimeTakenNanos.longValue() == 0L || this.getCacheGets() == 0L) {
            return 0.0f;
        }
        return this.cacheGetTimeTakenNanos.longValue() / this.getCacheGets() / 1000L;
    }

    public float getAveragePutTime() {
        if (this.cachePutTimeTakenNanos.longValue() == 0L || this.getCacheGets() == 0L) {
            return 0.0f;
        }
        return this.cachePutTimeTakenNanos.longValue() / this.getCacheGets() / 1000L;
    }

    public float getAverageRemoveTime() {
        if (this.cacheRemoveTimeTakenNanos.longValue() == 0L || this.getCacheGets() == 0L) {
            return 0.0f;
        }
        return this.cacheRemoveTimeTakenNanos.longValue() / this.getCacheGets() / 1000L;
    }

    public void increaseCacheRemovals(long number) {
        this.cacheRemovals.getAndAdd(number);
    }

    public void increaseCacheExpiries(long number) {
        this.cacheExpiries.getAndAdd(number);
    }

    public void increaseCachePuts(long number) {
        this.cachePuts.getAndAdd(number);
    }

    public void increaseCacheHits(long number) {
        this.cacheHits.getAndAdd(number);
    }

    public void increaseCacheMisses(long number) {
        this.cacheMisses.getAndAdd(number);
    }

    public void increaseCacheEvictions(long number) {
        this.cacheEvictions.getAndAdd(number);
    }

    public void addGetTimeNano(long duration) {
        if (this.cacheGetTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cacheGetTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.cacheGetTimeTakenNanos.set(duration);
        }
    }

    public void addPutTimeNano(long duration) {
        if (this.cachePutTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cachePutTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.cachePutTimeTakenNanos.set(duration);
        }
    }

    public void addRemoveTimeNano(long duration) {
        if (this.cacheRemoveTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cacheRemoveTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.cacheRemoveTimeTakenNanos.set(duration);
        }
    }
}

