/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.processor;

import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.processor.MutableEntry;
import org.jsr107.ri.RICachedValue;
import org.jsr107.ri.RIInternalConverter;
import org.jsr107.ri.event.RICacheEventDispatcher;
import org.jsr107.ri.processor.MutableEntryOperation;

public class EntryProcessorEntry<K, V>
implements MutableEntry<K, V> {
    private final K key;
    private final RICachedValue cachedValue;
    private final RIInternalConverter<V> converter;
    private V value;
    private MutableEntryOperation operation;
    private long now;
    private RICacheEventDispatcher<K, V> dispatcher;
    private CacheLoader<K, V> cacheLoader;

    public EntryProcessorEntry(RIInternalConverter<V> converter, K key, RICachedValue cachedValue, long now, RICacheEventDispatcher<K, V> dispatcher, CacheLoader<K, V> cacheLoader) {
        this.converter = converter;
        this.key = key;
        this.cachedValue = cachedValue;
        this.operation = MutableEntryOperation.NONE;
        this.value = null;
        this.now = now;
        this.dispatcher = dispatcher;
        this.cacheLoader = cacheLoader;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        if (this.operation == MutableEntryOperation.NONE) {
            if (this.cachedValue == null || this.cachedValue.isExpiredAt(this.now)) {
                this.value = null;
            } else if (this.value == null) {
                Object internalValue = this.cachedValue.getInternalValue(this.now);
                this.value = internalValue == null ? null : this.converter.fromInternal(internalValue);
                Object v0 = this.value;
            }
        }
        if (this.value != null) {
            if (this.operation == MutableEntryOperation.NONE) {
                this.operation = MutableEntryOperation.ACCESS;
            }
        } else if (this.cacheLoader != null) {
            try {
                this.value = this.cacheLoader.load(this.key);
                if (this.value != null) {
                    this.operation = MutableEntryOperation.LOAD;
                }
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                }
                throw e;
            }
        }
        return this.value;
    }

    public boolean exists() {
        return this.operation == MutableEntryOperation.NONE && this.cachedValue != null && !this.cachedValue.isExpiredAt(this.now) || this.value != null;
    }

    public void remove() {
        this.operation = this.operation == MutableEntryOperation.CREATE || this.operation == MutableEntryOperation.LOAD ? MutableEntryOperation.NONE : MutableEntryOperation.REMOVE;
        this.value = null;
    }

    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.operation = this.cachedValue == null || this.cachedValue.isExpiredAt(this.now) ? MutableEntryOperation.CREATE : MutableEntryOperation.UPDATE;
        this.value = value;
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new IllegalArgumentException("Can't unwrap an EntryProcessor Entry");
    }

    public MutableEntryOperation getOperation() {
        return this.operation;
    }
}

