/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import org.jsr107.ri.annotations.AbstractKeyedCacheInterceptor;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.CachePutMethodDetails;
import org.jsr107.ri.annotations.ClassFilter;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;

public abstract class AbstractCachePutInterceptor<I>
extends AbstractKeyedCacheInterceptor<I, CachePutMethodDetails> {
    public Object cachePut(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheKeyInvocationContext<Annotation> cacheKeyInvocationContext = cacheContextSource.getCacheKeyInvocationContext(invocation);
        CachePutMethodDetails methodDetails = (CachePutMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_PUT);
        CachePut cachePutAnnotation = (CachePut)methodDetails.getCacheAnnotation();
        boolean afterInvocation = cachePutAnnotation.afterInvocation();
        CacheInvocationParameter valueParameter = cacheKeyInvocationContext.getValueParameter();
        Object value = valueParameter.getValue();
        if (!afterInvocation) {
            this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
        }
        try {
            result = this.proceed(invocation);
        }
        catch (Throwable t) {
            Class[] noCacheFor;
            Class[] cacheFor;
            boolean cache;
            if (afterInvocation && (cache = ClassFilter.isIncluded(t, cacheFor = cachePutAnnotation.cacheFor(), noCacheFor = cachePutAnnotation.noCacheFor(), false))) {
                this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
            }
            throw t;
        }
        if (afterInvocation) {
            this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
        }
        return result;
    }

    protected void cacheValue(InternalCacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext, CachePutMethodDetails methodDetails, Object value) {
        Object cachedValue = value;
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        cache.put((Object)cacheKey, cachedValue);
    }
}

