/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;

public class BeanManagerUtil {
    @Inject
    private BeanManager beanManager;

    public <T> T getBeanByType(Class<T> type, Annotation ... qualifiers) {
        if (type == null) {
            throw new IllegalArgumentException("CDI Bean type cannot be null");
        }
        Set beans = this.beanManager.getBeans(type, qualifiers);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = this.beanManager.resolve(beans);
        CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
        Object result = this.beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
        return (T)result;
    }
}

