/*
 * Decompiled with CFR 0.152.
 */
package muster.codec.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import muster.MappingException;
import muster.ast.AstNode;
import muster.ast.BoolNode;
import muster.ast.FalseNode$;
import muster.ast.NullNode$;
import muster.ast.NumberNode;
import muster.ast.ObjectNode;
import muster.ast.TextNode;
import muster.ast.TrueNode$;
import muster.ast.UndefinedNode$;
import muster.codec.jackson.JacksonInputCursor$class;
import muster.input.InputCursor;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015v!B\u0001\u0003\u0011\u0013I\u0011A\u0005&bG.\u001cxN\\%oaV$8)\u001e:t_JT!a\u0001\u0003\u0002\u000f)\f7m[:p]*\u0011QAB\u0001\u0006G>$Wm\u0019\u0006\u0002\u000f\u00051Q.^:uKJ\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!%QB\u0001\nKC\u000e\\7o\u001c8J]B,HoQ;sg>\u00148CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0004\u00051-1\u0011DA\tKC\u000e\\7o\u001c8PE*,7\r\u001e(pI\u0016\u001c\"a\u0006\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011aA1ti&\u0011q\u0004\b\u0002\u000b\u001f\nTWm\u0019;O_\u0012,\u0007\u0002C\u0011\u0018\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\rA\f'/\u001a8u!\t\u00193&D\u0001%\u0015\t)c%\u0001\u0005eCR\f'-\u001b8e\u0015\t\u0019qE\u0003\u0002)S\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0002U\u0005\u00191m\\7\n\u00051\"#\u0001\u0003&t_:tu\u000eZ3\t\u000bU9B\u0011\u0001\u0018\u0015\u0005=\n\u0004C\u0001\u0019\u0018\u001b\u0005Y\u0001\"B\u0011.\u0001\u0004\u0011\u0003\"B\u001a\u0018\t\u0003!\u0014!\u0003:fC\u00124\u0015.\u001a7e)\t)D\t\r\u00027wA\u00191dN\u001d\n\u0005ab\"aB!ti:{G-\u001a\t\u0003umb\u0001\u0001B\u0005=e\u0005\u0005\t\u0011!B\u0001{\t\u0019q\fJ\u0019\u0012\u0005y\n\u0005CA\b@\u0013\t\u0001\u0005CA\u0004O_RD\u0017N\\4\u0011\u0005=\u0011\u0015BA\"\u0011\u0005\r\te.\u001f\u0005\u0006\u000bJ\u0002\rAR\u0001\nM&,G\u000e\u001a(b[\u0016\u0004\"a\u0012&\u000f\u0005=A\u0015BA%\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u0003\u0002B\u0002(\u0018A\u0013%q*A\nsK\u0006$g)[3mI\u001a\u0013x.\u001c)be\u0016tG\u000f\u0006\u0002#!\")\u0011+\u0014a\u0001\r\u0006!a.Y7f\u0011\u0015\u0019v\u0003\"\u0001U\u0003E\u0011X-\u00193BeJ\f\u0017PR5fY\u0012|\u0005\u000f\u001e\u000b\u0003+n\u00032a\u0004,Y\u0013\t9\u0006C\u0001\u0004PaRLwN\u001c\t\u00037eK!A\u0017\u000f\u0003\u0013\u0005\u0013(/Y=O_\u0012,\u0007\"B#S\u0001\u00041\u0005\"B/\u0018\t\u0003q\u0016A\u0005:fC\u0012|%M[3di\u001aKW\r\u001c3PaR$\"a\u00181\u0011\u0007=1&\u0004C\u0003F9\u0002\u0007a\tC\u0003c/\u0011\u00051-\u0001\nsK\u0006$7\u000b\u001e:j]\u001e4\u0015.\u001a7e\u001fB$HC\u00013i!\rya+\u001a\t\u00037\u0019L!a\u001a\u000f\u0003\u0011Q+\u0007\u0010\u001e(pI\u0016DQ!R1A\u0002\u0019CQA[\f\u0005\u0002-\f1C]3bI\n{w\u000e\\3b]\u001aKW\r\u001c3PaR$\"\u0001\u001c9\u0011\u0007=1V\u000e\u0005\u0002\u001c]&\u0011q\u000e\b\u0002\t\u0005>|GNT8eK\")Q)\u001ba\u0001\r\")!o\u0006C\u0001g\u0006\u0011\"/Z1e\u001dVl'-\u001a:GS\u0016dGm\u00149u)\t!\b\u0010E\u0002\u0010-V\u0004\"a\u0007<\n\u0005]d\"A\u0003(v[\n,'OT8eK\")Q)\u001da\u0001\r\")!p\u0006C\u0001w\u000611.Z=TKR,\u0012\u0001 \t\u0004\u000fv4\u0015B\u0001@M\u0005\r\u0019V\r\u001e\u0005\b\u0003\u00039B\u0011AA\u0002\u00031YW-_:Ji\u0016\u0014\u0018\r^8s+\t\t)\u0001E\u0003\u0002\b\u0005]aI\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0019\u0011Q\u0003\t\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005!IE/\u001a:bi>\u0014(bAA\u000b!\u00191\u0011qD\u0006\u0007\u0003C\u0011\u0001CS1dWN|g.\u0011:sCftu\u000eZ3\u0014\u000b\u0005u\u0001,a\t\u0011\t)\t)C\t\u0004\n\u0019\t\u0001\n1!\u0001\u0003\u0003O)B!!\u000b\u0002:M)\u0011Q\u0005\b\u0002,A1\u0011QFA\u001a\u0003oi!!a\f\u000b\u0007\u0005Eb!A\u0003j]B,H/\u0003\u0003\u00026\u0005=\"aC%oaV$8)\u001e:t_J\u00042AOA\u001d\t\u001d\tY$!\nC\u0002u\u0012\u0011A\u0015\u0005\t\u0003\u007f\t)\u0003\"\u0001\u0002B\u00051A%\u001b8ji\u0012\"\"!a\u0011\u0011\u0007=\t)%C\u0002\u0002HA\u0011A!\u00168ji\"A\u00111JA\u0013\r#\ti%\u0001\u0003o_\u0012,W#\u0001\u0012\t\u0011\u0005E\u0013Q\u0005C\u0001\u0003'\nAB]3bI\u0006\u0013(/Y=PaR$\u0012!\u0016\u0005\t\u0003/\n)\u0003\"\u0001\u0002Z\u0005i!/Z1e\u001f\nTWm\u0019;PaR$\u0012a\u0018\u0005\t\u0003;\n)\u0003\"\u0001\u0002`\u0005i!/Z1e'R\u0014\u0018N\\4PaR$\u0012\u0001\u001a\u0005\t\u0003G\n)\u0003\"\u0001\u0002f\u0005q!/Z1e\u0005>|G.Z1o\u001fB$H#\u00017\t\u0011\u0005%\u0014Q\u0005C\u0001\u0003W\nQB]3bI:+XNY3s\u001fB$H#\u0001;\t\u0011\u0005=\u0014Q\u0005C\u0001\u0003c\n\u0001B\\3yi:{G-\u001a\u000b\u0003\u0003g\u0002D!!\u001e\u0002zA!1dNA<!\rQ\u0014\u0011\u0010\u0003\f\u0003w\ni'!A\u0001\u0002\u000b\u0005QHA\u0002`IIB1\"a \u0002\u001e\t\u0015\r\u0011\"\u0001\u0002N\u000511o\\;sG\u0016D!\"a!\u0002\u001e\t\u0005\t\u0015!\u0003#\u0003\u001d\u0019x.\u001e:dK\u0002Bq!FA\u000f\t\u0003\t9\t\u0006\u0003\u0002\n\u0006-\u0005c\u0001\u0019\u0002\u001e!9\u0011qPAC\u0001\u0004\u0011\u0003\"CAH\u0003;\u0001\u000b\u0015BAI\u0003\rIG\r\u001f\t\u0004\u001f\u0005M\u0015bAAK!\t\u0019\u0011J\u001c;\t\u0011\u0005-\u0013Q\u0004C\t\u0003\u001bB\u0001\"a'\u0002\u001e\u0011\u0005\u0013QT\u0001\fQ\u0006\u001ch*\u001a=u\u001d>$W-\u0006\u0002\u0002 B\u0019q\"!)\n\u0007\u0005\r\u0006CA\u0004C_>dW-\u00198")
public interface JacksonInputCursor<R>
extends InputCursor<R> {
    public JsonNode node();

    public Option<muster.ast.ArrayNode> readArrayOpt();

    public Option<ObjectNode> readObjectOpt();

    public Option<TextNode> readStringOpt();

    public Option<BoolNode> readBooleanOpt();

    public Option<NumberNode> readNumberOpt();

    public AstNode<?> nextNode();

    public static final class JacksonArrayNode
    extends muster.ast.ArrayNode
    implements JacksonInputCursor<JsonNode> {
        private final JsonNode source;
        private int idx;

        @Override
        public Option<muster.ast.ArrayNode> readArrayOpt() {
            return JacksonInputCursor$class.readArrayOpt(this);
        }

        @Override
        public Option<ObjectNode> readObjectOpt() {
            return JacksonInputCursor$class.readObjectOpt(this);
        }

        @Override
        public Option<TextNode> readStringOpt() {
            return JacksonInputCursor$class.readStringOpt(this);
        }

        @Override
        public Option<BoolNode> readBooleanOpt() {
            return JacksonInputCursor$class.readBooleanOpt(this);
        }

        @Override
        public Option<NumberNode> readNumberOpt() {
            return JacksonInputCursor$class.readNumberOpt(this);
        }

        @Override
        public AstNode<?> nextNode() {
            return JacksonInputCursor$class.nextNode(this);
        }

        public JsonNode source() {
            return this.source;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JsonNode node() {
            void var1_1;
            JsonNode c = this.source().get(this.idx);
            ++this.idx;
            return var1_1;
        }

        public boolean hasNextNode() {
            return ((ArrayNode)this.source()).size() > this.idx;
        }

        public JacksonArrayNode(JsonNode source) {
            this.source = source;
            super(null);
            JacksonInputCursor$class.$init$(this);
            this.idx = 0;
        }
    }

    public static final class JacksonObjectNode
    extends ObjectNode {
        private final JsonNode parent;

        public AstNode<?> readField(String fieldName) {
            block9: {
                Object object;
                block3: {
                    JsonNode node;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            node = this.readFieldFromParent(fieldName);
                                            if (!node.isNull()) break block2;
                                            object = NullNode$.MODULE$;
                                            break block3;
                                        }
                                        if (!node.isMissingNode()) break block4;
                                        object = UndefinedNode$.MODULE$;
                                        break block3;
                                    }
                                    if (!node.isArray()) break block5;
                                    object = new JacksonArrayNode(node);
                                    break block3;
                                }
                                if (!node.isObject()) break block6;
                                object = new JacksonObjectNode(node);
                                break block3;
                            }
                            if (!node.isTextual()) break block7;
                            object = new TextNode(node.asText());
                            break block3;
                        }
                        if (!node.isNumber()) break block8;
                        object = new NumberNode(node.asText());
                        break block3;
                    }
                    if (!node.isBoolean()) break block9;
                    object = node.asBoolean() ? TrueNode$.MODULE$ : FalseNode$.MODULE$;
                }
                return object;
            }
            throw new MappingException("Unable to determine the type of this json");
        }

        private JsonNode readFieldFromParent(String name) {
            return this.parent.has(name) ? this.parent.get(name) : NullNode.getInstance();
        }

        public Option<muster.ast.ArrayNode> readArrayFieldOpt(String fieldName) {
            JsonNode node;
            block4: {
                None$ none$;
                block3: {
                    block2: {
                        node = this.readFieldFromParent(fieldName);
                        if (!node.isNull() && !node.isMissingNode()) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!node.isArray()) break block4;
                    none$ = new Some((Object)new JacksonArrayNode(node));
                }
                return none$;
            }
            throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an array field but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
        }

        public Option<ObjectNode> readObjectFieldOpt(String fieldName) {
            JsonNode node;
            block4: {
                None$ none$;
                block3: {
                    block2: {
                        node = this.readFieldFromParent(fieldName);
                        if (!node.isNull() && !node.isMissingNode()) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!node.isObject()) break block4;
                    none$ = new Some((Object)new JacksonObjectNode(node));
                }
                return none$;
            }
            throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an object field but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
        }

        public Option<TextNode> readStringFieldOpt(String fieldName) {
            JsonNode node;
            block4: {
                None$ none$;
                block3: {
                    block2: {
                        node = this.readFieldFromParent(fieldName);
                        if (!node.isNull() && !node.isMissingNode()) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!node.isTextual()) break block4;
                    none$ = new Some((Object)new TextNode(node.asText()));
                }
                return none$;
            }
            throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a string field but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
        }

        public Option<BoolNode> readBooleanFieldOpt(String fieldName) {
            JsonNode node;
            block4: {
                None$ none$;
                block3: {
                    block2: {
                        node = this.readFieldFromParent(fieldName);
                        if (!node.isNull() && !node.isMissingNode()) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!node.isBoolean()) break block4;
                    none$ = new Some(node.asBoolean() ? TrueNode$.MODULE$ : FalseNode$.MODULE$);
                }
                return none$;
            }
            throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a boolean field but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
        }

        public Option<NumberNode> readNumberFieldOpt(String fieldName) {
            JsonNode node;
            block5: {
                None$ none$;
                block3: {
                    block4: {
                        block2: {
                            node = this.readFieldFromParent(fieldName);
                            if (!node.isNull() && !node.isMissingNode()) break block2;
                            none$ = None$.MODULE$;
                            break block3;
                        }
                        if (!node.isTextual()) break block4;
                        none$ = new Some((Object)new NumberNode(node.asText()));
                        break block3;
                    }
                    if (!node.isNumber()) break block5;
                    none$ = new Some((Object)new NumberNode(node.asText()));
                }
                return none$;
            }
            throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a number field but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
        }

        public Set<String> keySet() {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(this.parent.fieldNames()).asScala()).toSet();
        }

        public Iterator<String> keysIterator() {
            return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.parent.fieldNames()).asScala();
        }

        public JacksonObjectNode(JsonNode parent) {
            this.parent = parent;
            super(null);
        }
    }
}

