/*
 * Decompiled with CFR 0.152.
 */
package muster.codec.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import muster.MappingException;
import muster.ParseException;
import muster.ParseLocation;
import muster.ast.ArrayNode;
import muster.ast.AstNode;
import muster.ast.BigDecimalNode;
import muster.ast.BigIntNode;
import muster.ast.BoolNode;
import muster.ast.ByteNode;
import muster.ast.DoubleNode;
import muster.ast.FloatNode;
import muster.ast.IntNode;
import muster.ast.LongNode;
import muster.ast.NumberNode;
import muster.ast.ObjectNode;
import muster.ast.ShortNode;
import muster.ast.TextNode;
import muster.codec.jackson.JacksonCodec$;
import muster.codec.jackson.JacksonInputCursor;
import muster.codec.jackson.JacksonInputCursor$class;
import muster.codec.json.JsonRenderer;
import muster.codec.json.JsonRenderer$;
import muster.input.AstCursor;
import muster.input.ByteArrayConsumable;
import muster.input.ByteBufferConsumable;
import muster.input.ByteChannelConsumable;
import muster.input.Consumable;
import muster.input.Consumer;
import muster.input.CursorFailures;
import muster.input.FileConsumable;
import muster.input.InputFormat;
import muster.input.InputStreamConsumable;
import muster.input.ReaderConsumable;
import muster.input.StringConsumable;
import muster.input.URLConsumable;
import muster.output.Producible;
import muster.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;

public final class JacksonCodec$
extends JsonRenderer<String>
implements InputFormat<Consumable<?>, JacksonInputCursor<?>> {
    public static final JacksonCodec$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new JacksonCodec$();
    }

    public Object as(Object source, Consumer consumer) {
        return InputFormat.class.as((InputFormat)this, (Object)source, (Consumer)consumer);
    }

    public Try tryAs(Object source, Consumer consumer) {
        return InputFormat.class.tryAs((InputFormat)this, (Object)source, (Consumer)consumer);
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private <T> JacksonInputCursor<T> jic(T src, Function1<T, JsonNode> fn) {
        return new JacksonInputCursor<T>(src, fn){
            private final JsonNode node;
            private final T source;
            public final Object src$1;
            public final Function1 fn$1;

            public Option<ArrayNode> readArrayOpt() {
                return JacksonInputCursor$class.readArrayOpt(this);
            }

            public Option<ObjectNode> readObjectOpt() {
                return JacksonInputCursor$class.readObjectOpt(this);
            }

            public Option<TextNode> readStringOpt() {
                return JacksonInputCursor$class.readStringOpt(this);
            }

            public Option<BoolNode> readBooleanOpt() {
                return JacksonInputCursor$class.readBooleanOpt(this);
            }

            public Option<NumberNode> readNumberOpt() {
                return JacksonInputCursor$class.readNumberOpt(this);
            }

            public AstNode<?> nextNode() {
                return JacksonInputCursor$class.nextNode(this);
            }

            public ArrayNode readArray() {
                return AstCursor.class.readArray((AstCursor)this);
            }

            public ObjectNode readObject() {
                return AstCursor.class.readObject((AstCursor)this);
            }

            public TextNode readString() {
                return AstCursor.class.readString((AstCursor)this);
            }

            public BoolNode readBoolean() {
                return AstCursor.class.readBoolean((AstCursor)this);
            }

            public NumberNode readNumber() {
                return AstCursor.class.readNumber((AstCursor)this);
            }

            public ByteNode readByte() {
                return AstCursor.class.readByte((AstCursor)this);
            }

            public ShortNode readShort() {
                return AstCursor.class.readShort((AstCursor)this);
            }

            public IntNode readInt() {
                return AstCursor.class.readInt((AstCursor)this);
            }

            public LongNode readLong() {
                return AstCursor.class.readLong((AstCursor)this);
            }

            public BigIntNode readBigInt() {
                return AstCursor.class.readBigInt((AstCursor)this);
            }

            public FloatNode readFloat() {
                return AstCursor.class.readFloat((AstCursor)this);
            }

            public DoubleNode readDouble() {
                return AstCursor.class.readDouble((AstCursor)this);
            }

            public BigDecimalNode readBigDecimal() {
                return AstCursor.class.readBigDecimal((AstCursor)this);
            }

            public Option<ByteNode> readByteOpt() {
                return AstCursor.class.readByteOpt((AstCursor)this);
            }

            public Option<ShortNode> readShortOpt() {
                return AstCursor.class.readShortOpt((AstCursor)this);
            }

            public Option<IntNode> readIntOpt() {
                return AstCursor.class.readIntOpt((AstCursor)this);
            }

            public Option<LongNode> readLongOpt() {
                return AstCursor.class.readLongOpt((AstCursor)this);
            }

            public Option<BigIntNode> readBigIntOpt() {
                return AstCursor.class.readBigIntOpt((AstCursor)this);
            }

            public Option<FloatNode> readFloatOpt() {
                return AstCursor.class.readFloatOpt((AstCursor)this);
            }

            public Option<DoubleNode> readDoubleOpt() {
                return AstCursor.class.readDoubleOpt((AstCursor)this);
            }

            public Option<BigDecimalNode> readBigDecimalOpt() {
                return AstCursor.class.readBigDecimalOpt((AstCursor)this);
            }

            public boolean hasNextNode() {
                return AstCursor.class.hasNextNode((AstCursor)this);
            }

            public Nothing$ failStructure(String msg) {
                return CursorFailures.class.failStructure((CursorFailures)this, (String)msg);
            }

            public JsonNode node() {
                return this.node;
            }

            public T source() {
                return this.source;
            }
            {
                this.src$1 = src$1;
                this.fn$1 = fn$1;
                CursorFailures.class.$init$((CursorFailures)this);
                AstCursor.class.$init$((AstCursor)this);
                JacksonInputCursor$class.$init$(this);
                this.node = (JsonNode)Try$.MODULE$.apply((Function0)new Serializable(this){
                    private final /* synthetic */ anon.1 $outer;

                    public final JsonNode apply() {
                        return (JsonNode)this.$outer.fn$1.apply(this.$outer.src$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){

                    public final MissingNode apply() {
                        return MissingNode.getInstance();
                    }
                });
                this.source = src$1;
            }
        };
    }

    public JacksonInputCursor<?> createCursor(Consumable<?> in) {
        try {
            block22: {
                JacksonInputCursor<Object> jacksonInputCursor;
                block15: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block14: {
                                                if (!(in instanceof StringConsumable)) break block14;
                                                StringConsumable stringConsumable = (StringConsumable)in;
                                                Serializable serializable = new Serializable(){

                                                    public final JsonNode apply(String x$1) {
                                                        return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                                    }
                                                };
                                                String string = stringConsumable.value();
                                                jacksonInputCursor = new /* invalid duplicate definition of identical inner class */;
                                                break block15;
                                            }
                                            if (!(in instanceof FileConsumable)) break block16;
                                            FileConsumable fileConsumable = (FileConsumable)in;
                                            Serializable serializable = new Serializable(){

                                                public final JsonNode apply(File x$1) {
                                                    return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                                }
                                            };
                                            File file = fileConsumable.value();
                                            jacksonInputCursor = new /* invalid duplicate definition of identical inner class */;
                                            break block15;
                                        }
                                        if (!(in instanceof ReaderConsumable)) break block17;
                                        ReaderConsumable readerConsumable = (ReaderConsumable)in;
                                        Serializable serializable = new Serializable(){

                                            public final JsonNode apply(Reader x$1) {
                                                return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                            }
                                        };
                                        Reader reader = readerConsumable.value();
                                        jacksonInputCursor = new /* invalid duplicate definition of identical inner class */;
                                        break block15;
                                    }
                                    if (!(in instanceof InputStreamConsumable)) break block18;
                                    InputStreamConsumable inputStreamConsumable = (InputStreamConsumable)in;
                                    jacksonInputCursor = this.jic((Object)inputStreamConsumable.value(), (Function1)new Serializable(){

                                        public final JsonNode apply(InputStream x$1) {
                                            return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                        }
                                    });
                                    break block15;
                                }
                                if (!(in instanceof ByteArrayConsumable)) break block19;
                                ByteArrayConsumable byteArrayConsumable = (ByteArrayConsumable)in;
                                jacksonInputCursor = this.jic((Object)byteArrayConsumable.value(), (Function1)new Serializable(){

                                    public final JsonNode apply(byte[] x$1) {
                                        return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                    }
                                });
                                break block15;
                            }
                            if (!(in instanceof URLConsumable)) break block20;
                            URLConsumable uRLConsumable = (URLConsumable)in;
                            jacksonInputCursor = this.jic((Object)uRLConsumable.value(), (Function1)new Serializable(){

                                public final JsonNode apply(URL x$1) {
                                    return JacksonCodec$.MODULE$.mapper().readTree(x$1);
                                }
                            });
                            break block15;
                        }
                        if (!(in instanceof ByteChannelConsumable)) break block21;
                        ByteChannelConsumable byteChannelConsumable = (ByteChannelConsumable)in;
                        jacksonInputCursor = this.jic((Object)byteChannelConsumable.value(), (Function1)new Serializable(){

                            public final JsonNode apply(ReadableByteChannel ch) {
                                return JacksonCodec$.MODULE$.mapper().readTree(Channels.newReader(ch, StandardCharsets.UTF_8.name()));
                            }
                        });
                        break block15;
                    }
                    if (!(in instanceof ByteBufferConsumable)) break block22;
                    ByteBufferConsumable byteBufferConsumable = (ByteBufferConsumable)in;
                    jacksonInputCursor = this.jic((Object)byteBufferConsumable.value(), (Function1)new Serializable(){

                        public final JsonNode apply(ByteBuffer ch) {
                            return JacksonCodec$.MODULE$.mapper().readTree(package$.MODULE$.Consumable().byteBufferInputStream(ch));
                        }
                    });
                }
                return jacksonInputCursor;
            }
            throw new MatchError(in);
        }
        catch (JsonMappingException jsonMappingException) {
            throw new MappingException(jsonMappingException.getMessage());
        }
        catch (JsonParseException jsonParseException) {
            None$ none$;
            Option option = Option$.MODULE$.apply((Object)jsonParseException.getLocation());
            if (!option.isEmpty()) {
                None$ none$2;
                JsonLocation jsonLocation = (JsonLocation)option.get();
                Object x11 = jsonLocation.getSourceRef();
                if (x11 == null) {
                    none$2 = None$.MODULE$;
                } else if (x11 instanceof File) {
                    File x31 = (File)x11;
                    none$2 = new Some((Object)x31.getAbsolutePath());
                } else if (x11 instanceof URL) {
                    URL x41 = (URL)x11;
                    none$2 = new Some((Object)x41.toExternalForm());
                } else {
                    none$2 = new Some((Object)x11.toString());
                }
                Some some = new Some((Object)new ParseLocation(jsonLocation.getLineNr(), jsonLocation.getColumnNr(), (Option)none$2));
                none$ = some;
            } else {
                none$ = None$.MODULE$;
            }
            None$ loc = none$;
            throw new ParseException(jsonParseException.getOriginalMessage(), (Option)loc);
        }
    }

    private JacksonCodec$() {
        super((Producible)package$.MODULE$.StringProducible(), JsonRenderer$.MODULE$.$lessinit$greater$default$2());
        MODULE$ = this;
        InputFormat.class.$init$((InputFormat)this);
        this.mapper = new ObjectMapper();
        this.mapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

