/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.maven;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jsimpledb.DefaultStorageIdGenerator;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleDBFactory;
import org.jsimpledb.StorageIdGenerator;
import org.jsimpledb.annotation.JFieldType;
import org.jsimpledb.annotation.JSimpleClass;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.spring.JSimpleDBClassScanner;
import org.jsimpledb.spring.JSimpleDBFieldTypeScanner;

public abstract class AbstractSchemaMojo
extends AbstractMojo {
    @Parameter
    protected String[] packages;
    @Parameter
    protected String[] classes;
    @Parameter
    protected String storageIdGeneratorClass;
    @Parameter(defaultValue="")
    protected String schemaVersionProperty;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected abstract File getClassOutputDirectory();

    protected abstract void addDependencyClasspathElements(List<String> var1) throws DependencyResolutionRequiredException;

    protected abstract void execute(JSimpleDB var1) throws MojoExecutionException, MojoFailureException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        TreeSet<URL> urls = new TreeSet<URL>(new Comparator<URL>(){

            @Override
            public int compare(URL url1, URL url2) {
                return url1.toString().compareTo(url2.toString());
            }
        });
        try {
            urls.add(this.getClassOutputDirectory().toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("error creating URL from directory `" + this.getClassOutputDirectory() + "'", (Exception)e);
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        try {
            this.addDependencyClasspathElements(dependencies);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("error gathering dependency classpath elements", (Exception)((Object)e));
        }
        for (String dependency : dependencies) {
            try {
                urls.add(new File(dependency).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("error creating URL from classpath element `" + dependency + "'", (Exception)e);
            }
        }
        if (this.classes == null && this.packages == null) {
            final ArrayList classNames = new ArrayList();
            final Path dir = this.getClassOutputDirectory().toPath();
            try {
                Files.walkFileTree(this.getClassOutputDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if ((path = dir.relativize(path)).getNameCount() == 0 || !path.getName(path.getNameCount() - 1).toString().endsWith(".class")) {
                            return FileVisitResult.CONTINUE;
                        }
                        StringBuilder buf = new StringBuilder();
                        for (Path component : path) {
                            if (buf.length() > 0) {
                                buf.append('.');
                            }
                            buf.append(component.toString());
                        }
                        String name = buf.toString();
                        name = name.substring(0, name.length() - ".class".length());
                        classNames.add(name);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("error walking output directory hierarchy", (Exception)e);
            }
            this.classes = classNames.toArray(new String[classNames.size()]);
            this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " auto-generated class list: " + classNames.toString().replaceAll("(^\\[|, )", "\n  ")));
        }
        this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " classloader setup: " + urls.toString().replaceAll("(^\\[|, )", "\n  ")));
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), parentLoader);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            SchemaModel schema;
            JSimpleDB jSimpleDB;
            DefaultStorageIdGenerator storageIdGenerator;
            HashSet modelClasses = new HashSet();
            HashSet fieldTypeClasses = new HashSet();
            if (this.packages != null && this.packages.length > 0) {
                void var10_21;
                String[] buf = new StringBuilder();
                String[] stringArray = this.packages;
                int n = stringArray.length;
                boolean bl = false;
                while (var10_21 < n) {
                    String packageName = stringArray[var10_21];
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(packageName);
                    ++var10_21;
                }
                String packageNames = buf.toString();
                this.getLog().info((CharSequence)("scanning for @JSimpleClass annotations in packages: " + packageNames));
                for (String string : new JSimpleDBClassScanner().scanForClasses(new String[]{packageNames})) {
                    this.getLog().info((CharSequence)("adding JSimpleDB model class " + string));
                    try {
                        modelClasses.add(Class.forName(string, false, Thread.currentThread().getContextClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new MojoExecutionException("failed to load model class `" + string + "'", (Exception)e);
                    }
                }
                this.getLog().info((CharSequence)("scanning for @JFieldType annotations in packages: " + packageNames));
                for (String string : new JSimpleDBFieldTypeScanner().scanForClasses(new String[]{packageNames})) {
                    this.getLog().info((CharSequence)("adding JSimpleDB field type class `" + string + "'"));
                    try {
                        fieldTypeClasses.add(Class.forName(string, false, Thread.currentThread().getContextClassLoader()));
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("failed to load field type class `" + string + "'", e);
                    }
                }
            }
            if (this.classes != null && this.classes.length > 0) {
                for (String string : this.classes) {
                    Class<?> cl;
                    try {
                        cl = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new MojoExecutionException("failed to load class `" + string + "'", (Exception)e);
                    }
                    if (cl.isAnnotationPresent(JSimpleClass.class)) {
                        this.getLog().info((CharSequence)("adding JSimpleDB model " + cl));
                        modelClasses.add(cl);
                    }
                    if (!cl.isAnnotationPresent(JFieldType.class)) continue;
                    this.getLog().info((CharSequence)("adding JSimpleDB field type " + cl));
                    fieldTypeClasses.add(cl);
                }
            }
            if (this.storageIdGeneratorClass != null) {
                try {
                    storageIdGenerator = Class.forName(this.storageIdGeneratorClass, false, Thread.currentThread().getContextClassLoader()).asSubclass(StorageIdGenerator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("error instantiatiating the configured <storageIdGeneratorClass> `" + this.storageIdGeneratorClass + "'", e);
                }
            } else {
                storageIdGenerator = new DefaultStorageIdGenerator();
            }
            Database db = new Database((KVDatabase)new SimpleKVDatabase());
            for (Class clazz : fieldTypeClasses) {
                FieldType<?> fieldType;
                this.getLog().info((CharSequence)("instantiating " + clazz + " as field type instance"));
                try {
                    fieldType = this.asFieldTypeClass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("failed to instantiate class `" + clazz.getName() + "'", e);
                }
                try {
                    db.getFieldTypeRegistry().add(fieldType);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("failed to register custom field type class `" + clazz.getName() + "'", e);
                }
            }
            JSimpleDBFactory factory = new JSimpleDBFactory();
            factory.setDatabase(db);
            factory.setSchemaVersion(1);
            factory.setStorageIdGenerator((StorageIdGenerator)storageIdGenerator);
            factory.setModelClasses(modelClasses);
            this.getLog().info((CharSequence)"generating JSimpleDB schema from schema classes");
            try {
                jSimpleDB = factory.newJSimpleDB();
                schema = jSimpleDB.getSchemaModel();
            }
            catch (Exception e) {
                throw new MojoFailureException("schema generation failed: " + e, (Throwable)e);
            }
            this.getLog().info((CharSequence)("auto-generate schema version is " + schema.autogenerateVersion()));
            if (this.schemaVersionProperty != null && this.schemaVersionProperty.length() > 0) {
                this.project.getProperties().setProperty(this.schemaVersionProperty, "" + schema.autogenerateVersion());
            }
            db.createTransaction(schema, 1, true).commit();
            this.execute(jSimpleDB);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentLoader);
        }
    }

    protected void generate(SchemaModel schema, File file) throws MojoExecutionException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            this.getLog().info((CharSequence)("creating directory `" + dir + "'"));
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("error creating directory `" + dir + "'", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("writing JSimpleDB schema to `" + file + "'"));
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            schema.toXML((OutputStream)output, true);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error writing schema to `" + file + "': " + e, (Exception)e);
        }
    }

    protected boolean verify(SchemaModel schema, File file, boolean matchNames) throws MojoExecutionException {
        boolean matched;
        SchemaModel verifyModel;
        this.getLog().info((CharSequence)("verifying JSimpleDB schema matches `" + file + "'"));
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            verifyModel = SchemaModel.fromXML((InputStream)input);
        }
        catch (IOException | InvalidSchemaException e) {
            throw new MojoExecutionException("error reading schema from `" + file + "': " + e, (Exception)e);
        }
        boolean bl = matched = matchNames ? schema.equals((Object)verifyModel) : schema.isCompatibleWith(verifyModel);
        if (!matched) {
            this.getLog().error((CharSequence)"schema verification failed:");
            this.getLog().error((CharSequence)schema.differencesFrom(verifyModel).toString());
        } else {
            this.getLog().info((CharSequence)"schema verification succeeded");
        }
        return matched;
    }

    protected boolean verify(JSimpleDB jdb, Iterator<? extends File> otherVersionFiles) throws MojoExecutionException {
        boolean success = true;
        while (otherVersionFiles.hasNext()) {
            SchemaModel otherSchema;
            File file = otherVersionFiles.next();
            this.getLog().info((CharSequence)("checking schema for conflicts with " + file));
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                otherSchema = SchemaModel.fromXML((InputStream)input);
            }
            catch (IOException | InvalidSchemaException e) {
                throw new MojoExecutionException("error reading schema from `" + file + "': " + e, (Exception)e);
            }
            try {
                jdb.getDatabase().createTransaction(otherSchema, 2, true).rollback();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("schema conflicts with " + file + ": " + e));
                success = false;
            }
        }
        return success;
    }

    private Class<? extends FieldType<?>> asFieldTypeClass(Class<?> klass) throws MojoExecutionException {
        try {
            return klass.asSubclass(FieldType.class);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("invalid @" + JFieldType.class.getSimpleName() + " annotation on " + klass + ": type is not a subclass of " + FieldType.class);
        }
    }
}

