/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IParameterScope;
import org.jrubyparser.ast.MethodNameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.util.VariableHelper;

public abstract class MethodDefNode
extends Node
implements INameNode,
ILocalScope,
IParameterScope {
    protected MethodNameNode nameNode;
    protected ArgsNode argsNode;
    protected StaticScope scope;
    protected Node bodyNode;

    public MethodDefNode(SourcePosition position, MethodNameNode nameNode, ArgsNode argsNode, StaticScope scope, Node bodyNode) {
        super(position);
        this.nameNode = (MethodNameNode)this.adopt(nameNode);
        this.argsNode = (ArgsNode)this.adopt(argsNode);
        this.scope = scope;
        this.bodyNode = this.adopt(bodyNode);
    }

    public ArgsNode getArgs() {
        return this.argsNode;
    }

    @Deprecated
    public ArgsNode getArgsNode() {
        return this.getArgs();
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public String getLexicalName() {
        return this.getName();
    }

    public MethodNameNode getNameNode() {
        return this.nameNode;
    }

    public String getName() {
        return this.nameNode.getName();
    }

    public void setName(String name) {
        this.nameNode.setName(name);
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getNameNode().getNamePosition();
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNameNode().getNamePosition();
    }

    public boolean isParameterUsed(String name) {
        return VariableHelper.isParameterUsed(this.getBody(), name, true);
    }

    public ILocalVariable getParameterNamed(String name) {
        return VariableHelper.getParameterName(this.getArgs(), name);
    }

    public String getNormativeSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.getName());
        List<String> args = this.getArgs().getNormativeParameterNameList(false);
        int length = args.size();
        if (length > 0) {
            signature.append('(').append(args.get(0));
            for (int i = 1; i < length; ++i) {
                signature.append(',').append(args.get(i));
            }
            signature.append(')');
        }
        return signature.toString();
    }
}

