/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IInstanceVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class InstVarNode
extends Node
implements IInstanceVariable {
    private String name;

    public InstVarNode(SourcePosition position, String name) {
        super(position);
        if (name.startsWith("@")) {
            name = name.substring(1);
        }
        this.name = name;
    }

    public NodeType getNodeType() {
        return NodeType.INSTVARNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstVarNode(this);
    }

    public String getLexicalName() {
        return "@" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromEnd(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getPosition();
    }
}

