/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.IInstanceVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.IInstanceVariableVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstAsgnNode
extends AssignableNode
implements IInstanceVariable {
    private String name;

    public InstAsgnNode(SourcePosition position, String name, Node valueNode) {
        super(position, valueNode);
        if (name.startsWith("@")) {
            name = name.substring(1);
        }
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INSTASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstAsgnNode(this);
    }

    @Override
    public String getLexicalName() {
        return "@" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Override
    public SourcePosition getNamePosition() {
        return this.getLexicalNamePosition().fromEnd(this.getName().length());
    }

    @Override
    public SourcePosition getLexicalNamePosition() {
        return this.getPosition().fromBeginning(this.getLexicalName().length());
    }

    public List<IInstanceVariable> getOccurences() {
        return IInstanceVariableVisitor.findOccurrencesIn((Node)((Object)this.getClosestModule()), this.getName());
    }
}

