/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.posix;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import jnr.constants.platform.Errno;
import jnr.posix.POSIXHandler;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.language.control.RaiseException;

public class TrufflePosixHandler
implements POSIXHandler {
    private final RubyContext context;

    public TrufflePosixHandler(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public void error(Errno errno, String methodName) {
        throw new RaiseException(ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getErrnoClass(errno), this.context.getCoreLibrary().getNilObject(), null, errno.intValue()));
    }

    public void error(Errno errno, String methodName, String extraData) {
        this.error(errno, methodName);
    }

    public void unimplementedError(String s) {
        throw new UnsupportedOperationException();
    }

    public void warn(POSIXHandler.WARNING_ID warning_id, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return false;
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.context.getCurrentDirectory());
    }

    public String[] getEnv() {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public PrintStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public int getPID() {
        return ((Object)((Object)this.context)).hashCode();
    }

    public PrintStream getErrorStream() {
        throw new UnsupportedOperationException();
    }
}

