/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.lexer;

import com.oracle.truffle.api.source.Source;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jruby.truffle.parser.ParserByteList;

public class LexerSource {
    private final Source source;
    private final int lineStartOffset;
    private ParserByteList sourceBytes;
    private int byteOffset;

    public LexerSource(Source source, int lineStartOffset, Encoding encoding) {
        this.source = source;
        this.lineStartOffset = lineStartOffset;
        this.sourceBytes = new ParserByteList(source.getCode().getBytes(StandardCharsets.UTF_8), encoding);
    }

    public Source getSource() {
        return this.source;
    }

    public Encoding getEncoding() {
        return this.sourceBytes.getEncoding();
    }

    public void setEncoding(Encoding encoding) {
        this.sourceBytes = this.sourceBytes.withEncoding(encoding);
    }

    public int getOffset() {
        return this.byteOffset;
    }

    public int getLineStartOffset() {
        return this.lineStartOffset;
    }

    public ParserByteList gets() {
        if (this.byteOffset >= this.sourceBytes.getLength()) {
            return null;
        }
        int lineEnd = this.nextNewLine() + 1;
        if (lineEnd == 0) {
            lineEnd = this.sourceBytes.getLength();
        }
        int start = this.byteOffset;
        int length = lineEnd - this.byteOffset;
        this.byteOffset = lineEnd;
        return this.sourceBytes.makeShared(start, length);
    }

    private int nextNewLine() {
        for (int n = this.byteOffset; n < this.sourceBytes.getLength(); ++n) {
            if (this.sourceBytes.charAt(n) != 10) continue;
            return n;
        }
        return -1;
    }
}

