/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchHeadNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

public class CallDispatchHeadNode
extends DispatchHeadNode {
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public static CallDispatchHeadNode createMethodCall() {
        return new CallDispatchHeadNode(false, MissingBehavior.CALL_METHOD_MISSING);
    }

    public static CallDispatchHeadNode createMethodCallIgnoreVisibility() {
        return new CallDispatchHeadNode(true, MissingBehavior.CALL_METHOD_MISSING);
    }

    public CallDispatchHeadNode(boolean ignoreVisibility, MissingBehavior missingBehavior) {
        super(ignoreVisibility, false, missingBehavior, DispatchAction.CALL_METHOD);
    }

    public Object call(VirtualFrame frame, Object receiver, Object method, Object ... arguments) {
        return this.dispatch(frame, receiver, method, null, arguments);
    }

    public Object callWithBlock(VirtualFrame frame, Object receiver, Object method, DynamicObject block, Object ... arguments) {
        return this.dispatch(frame, receiver, method, block, arguments);
    }

    public boolean callBoolean(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(null));
        }
        return this.booleanCastNode.executeToBoolean(this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects));
    }
}

