/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="value", type=RubyNode.class)
public abstract class FixnumLowerNode
extends RubyNode {
    @Specialization
    public int lower(int value) {
        return value;
    }

    @Specialization(guards={"canLower(value)"})
    public int lower(long value) {
        return (int)value;
    }

    @Specialization(guards={"!canLower(value)"})
    public long lowerFails(long value) {
        return value;
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)"})
    public Object passThrough(Object value) {
        return value;
    }

    protected static boolean canLower(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }
}

