/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChildren(value={@NodeChild(value="value"), @NodeChild(value="receiver"), @NodeChild(value="other")})
public abstract class CmpIntNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode gtNode;
    @Node.Child
    private CallDispatchHeadNode ltNode;

    public abstract int executeCmpInt(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    public int cmpInt(int value, Object receiver, Object other) {
        if (value > 0) {
            return 1;
        }
        if (value < 0) {
            return -1;
        }
        return 0;
    }

    @Specialization
    public int cmpLong(long value, Object receiver, Object other) {
        if (value > 0L) {
            return 1;
        }
        if (value < 0L) {
            return -1;
        }
        return 0;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public int cmpBignum(DynamicObject value, Object receiver, Object other) {
        return Layouts.BIGNUM.getValue(value).signum();
    }

    @Specialization(guards={"isNil(nil)"})
    public int cmpNil(Object nil, Object receiver, Object other) {
        throw new RaiseException(this.coreExceptions().argumentError(this.formatMessage(receiver, other), (Node)this));
    }

    @CompilerDirectives.TruffleBoundary
    private String formatMessage(Object receiver, Object other) {
        return StringUtils.format("comparison of %s with %s failed", Layouts.MODULE.getFields(this.coreLibrary().getLogicalClass(receiver)).getName(), Layouts.MODULE.getFields(this.coreLibrary().getLogicalClass(other)).getName());
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)", "!isRubyBignum(value)", "!isNil(value)"})
    public int cmpObject(VirtualFrame frame, Object value, Object receiver, Object other) {
        if (this.gtNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.gtNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall());
        }
        if (this.gtNode.callBoolean(frame, value, ">", null, 0)) {
            return 1;
        }
        if (this.ltNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ltNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall());
        }
        if (this.ltNode.callBoolean(frame, value, "<", null, 0)) {
            return -1;
        }
        return 0;
    }
}

