/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.language.LazyRubyRootNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.stdlib.CoverageManager;

@ProvidedTags(value={CoverageManager.LineTag.class, TraceManager.CallTag.class, TraceManager.ClassTag.class, TraceManager.LineTag.class, StandardTags.RootTag.class, StandardTags.StatementTag.class, StandardTags.CallTag.class})
public class RubyLanguage
extends TruffleLanguage<RubyContext> {
    public static final String PLATFORM = "java";
    public static final String RUBY_VERSION = "2.3.1";
    public static final int RUBY_REVISION = 54768;
    public static final String COMPILE_DATE = "2016-12-03";
    public static final String VERSION = "9.1.7.0-SNAPSHOT";
    public static final String ENGINE = "jruby+truffle";
    public static final String MIME_TYPE = "application/x-ruby";
    public static final String EXTENSION = ".rb";
    public static final String CEXT_MIME_TYPE = "application/x-sulong-library";
    public static final String CEXT_EXTENSION = ".su";
    public static final RubyLanguage INSTANCE = new RubyLanguage();

    private RubyLanguage() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String fileLine(SourceSection section) {
        Source source = section.getSource();
        if (section.isAvailable()) {
            return String.format("%s:%d", source.getName(), section.getStartLine());
        }
        return source.getName();
    }

    public RubyContext createContext(TruffleLanguage.Env env) {
        return new RubyContext(env);
    }

    protected void disposeContext(RubyContext context) {
        context.shutdown();
    }

    protected CallTarget parse(Source source, Node node, String ... argumentNames) throws IOException {
        return Truffle.getRuntime().createCallTarget((RootNode)new LazyRubyRootNode(null, null, source, argumentNames));
    }

    protected Object findExportedSymbol(RubyContext context, String s, boolean b) {
        return context.getInteropManager().findExportedObject(s);
    }

    protected Object getLanguageGlobal(RubyContext context) {
        return context.getCoreLibrary().getObjectClass();
    }

    protected boolean isObjectOfLanguage(Object object) {
        throw new UnsupportedOperationException();
    }

    protected Object evalInContext(Source source, Node node, MaterializedFrame mFrame) throws IOException {
        return null;
    }

    protected String toString(RubyContext context, Object value) {
        if (value == null) {
            return "<null>";
        }
        if (RubyGuards.isBoxedPrimitive(value) || RubyGuards.isRubyBasicObject(value)) {
            return context.send(value, "inspect", null, new Object[0]).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "<foreign>";
    }

    public Node unprotectedCreateFindContextNode() {
        return super.createFindContextNode();
    }

    public RubyContext unprotectedFindContext(Node node) {
        return (RubyContext)((Object)super.findContext(node));
    }
}

