/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import org.jruby.truffle.Log;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.options.MainExitException;
import org.jruby.truffle.options.OptionsBuilder;
import org.jruby.truffle.options.OptionsCatalog;
import org.jruby.truffle.options.OutputStrings;
import org.jruby.truffle.options.RubyInstanceConfig;
import org.jruby.truffle.platform.graal.Graal;

public class Main {
    private static final boolean METRICS_TIME = (Boolean)OptionsBuilder.readSystemProperty(OptionsCatalog.METRICS_TIME);
    private static final boolean METRICS_MEMORY_USED_ON_EXIT = (Boolean)OptionsBuilder.readSystemProperty(OptionsCatalog.METRICS_MEMORY_USED_ON_EXIT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode;
        Main.printTruffleTimeMetric("before-main");
        RubyInstanceConfig config = new RubyInstanceConfig();
        try {
            config.processArguments(args);
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                config.getError().println(mee.getMessage());
                if (mee.isUsageError()) {
                    Main.printUsage(config, true);
                }
            }
            System.exit(mee.getStatus());
        }
        Main.showVersion(config);
        Main.showCopyright(config);
        if (config.getShouldRunInterpreter()) {
            String filename = config.displayedFileName();
            PolyglotEngine engine = PolyglotEngine.newBuilder().config("application/x-ruby", OptionsCatalog.LOAD_PATHS.getName(), (Object)config.getLoadPaths().toArray(new String[0])).config("application/x-ruby", OptionsCatalog.REQUIRED_LIBRARIES.getName(), (Object)config.getRequiredLibraries().toArray(new String[0])).config("application/x-ruby", OptionsCatalog.INLINE_SCRIPT.getName(), (Object)config.inlineScript()).config("application/x-ruby", OptionsCatalog.ARGUMENTS.getName(), (Object)config.getArgv()).config("application/x-ruby", OptionsCatalog.DISPLAYED_FILE_NAME.getName(), (Object)config.displayedFileName()).config("application/x-ruby", OptionsCatalog.DEBUG.getName(), (Object)config.isDebug()).config("application/x-ruby", OptionsCatalog.VERBOSITY.getName(), (Object)config.getVerbosity().ordinal()).config("application/x-ruby", OptionsCatalog.FROZEN_STRING_LITERALS.getName(), (Object)config.isFrozenStringLiteral()).config("application/x-ruby", OptionsCatalog.DISABLE_GEMS.getName(), (Object)config.isDisableGems()).config("application/x-ruby", OptionsCatalog.INTERNAL_ENCODING.getName(), (Object)config.getInternalEncoding()).config("application/x-ruby", OptionsCatalog.EXTERNAL_ENCODING.getName(), (Object)config.getExternalEncoding()).build();
            Main.printTruffleTimeMetric("before-load-context");
            RubyContext context = (RubyContext)((Object)engine.eval(Main.loadSource("Truffle::Boot.context", "context")).as(RubyContext.class));
            Main.printTruffleTimeMetric("after-load-context");
            Main.printTruffleTimeMetric("before-run");
            try {
                if (config.isXFlag()) {
                    config.getError().println("jruby: no Ruby script found in input (LoadError)");
                    exitCode = 1;
                }
                if (config.getShouldCheckSyntax()) {
                    exitCode = Main.checkSyntax(engine, context, config.getScriptSource(), filename);
                }
                if (!Graal.isGraal() && context.getOptions().GRAAL_WARNING_UNLESS) {
                    Log.performanceOnce("This JVM does not have the Graal compiler - performance will be limited - see https://github.com/jruby/jruby/wiki/Truffle-FAQ#how-do-i-get-jrubytruffle");
                }
                if (config.shouldUsePathScript()) {
                    context.setOriginalInputFile(config.getScriptFileName());
                    exitCode = (Integer)engine.eval(Main.loadSource("Truffle::Boot.main_s", "main")).as(Integer.class);
                }
                context.setOriginalInputFile(filename);
                exitCode = (Integer)engine.eval(Main.loadSource("Truffle::Boot.main", "main")).as(Integer.class);
            }
            finally {
                Main.printTruffleTimeMetric("after-run");
                engine.dispose();
            }
        } else {
            Main.printUsage(config, false);
            exitCode = 1;
        }
        Main.printTruffleTimeMetric("after-main");
        Main.printTruffleMemoryMetric();
        System.exit(exitCode);
    }

    private static void printUsage(RubyInstanceConfig config, boolean force) {
        if (config.getShouldPrintUsage() || force) {
            config.getOutput().print(OutputStrings.getBasicUsageHelp());
        }
    }

    private static void showCopyright(RubyInstanceConfig config) {
        if (config.isShowCopyright()) {
            config.getOutput().println(OutputStrings.getCopyrightString());
        }
    }

    private static void showVersion(RubyInstanceConfig config) {
        if (config.isShowVersion()) {
            config.getOutput().println(OutputStrings.getVersionString());
        }
    }

    public static void printTruffleTimeMetric(String id) {
        if (METRICS_TIME) {
            long millis = System.currentTimeMillis();
            System.err.printf("%s %d.%03d%n", id, millis / 1000L, millis % 1000L);
        }
    }

    private static void printTruffleMemoryMetric() {
        if (!TruffleOptions.AOT && METRICS_MEMORY_USED_ON_EXIT) {
            for (int n = 0; n < 10; ++n) {
                System.gc();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            System.err.printf("allocated %d%n", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
        }
    }

    private static Source loadSource(String source, String name) {
        return Source.newBuilder((String)source).name(name).internal().mimeType("application/x-ruby").build();
    }

    private static int checkSyntax(PolyglotEngine engine, RubyContext context, InputStream in, String filename) {
        boolean status = Main.runCheckSyntax(engine, context, in, filename);
        for (String arg : context.getOptions().ARGUMENTS) {
            status = status && Main.checkFileSyntax(engine, context, arg);
        }
        return status ? 0 : 1;
    }

    private static boolean checkFileSyntax(PolyglotEngine engine, RubyContext context, String filename) {
        File file = new File(filename);
        if (file.exists()) {
            try {
                return Main.runCheckSyntax(engine, context, new FileInputStream(file), filename);
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("File not found: " + filename);
                return false;
            }
        }
        return false;
    }

    private static boolean runCheckSyntax(PolyglotEngine engine, RubyContext context, InputStream in, String filename) {
        context.setSyntaxCheckInputStream(in);
        context.setOriginalInputFile(filename);
        return (Boolean)engine.eval(Main.loadSource("Truffle::Boot.check_syntax", "check_syntax")).as(Boolean.class);
    }
}

