/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.util.ByteList;

public class SymbolParseNode
extends ParseNode
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final String name;
    private final Encoding encoding;

    public SymbolParseNode(ISourcePosition position, String name, Encoding encoding, int cr) {
        super(position, false);
        this.name = name;
        this.encoding = encoding == USASCIIEncoding.INSTANCE || cr == 16 ? USASCIIEncoding.INSTANCE : encoding;
    }

    public SymbolParseNode(ISourcePosition position, ByteList value) {
        super(position, false);
        this.name = value.toString().intern();
        if (value.getEncoding() != USASCIIEncoding.INSTANCE) {
            int size = value.realSize();
            this.encoding = value.getEncoding().strLength(value.unsafeBytes(), value.begin(), size) == size ? USASCIIEncoding.INSTANCE : value.getEncoding();
        } else {
            this.encoding = USASCIIEncoding.INSTANCE;
        }
    }

    public boolean equals(Object other) {
        return other instanceof SymbolParseNode && this.name.equals(((SymbolParseNode)other).getName()) && this.encoding == ((SymbolParseNode)other).getEncoding();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }
}

