/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;

public class InstrumentedWriteLocalVariableNode
extends WriteLocalVariableNode {
    private final String name;

    public InstrumentedWriteLocalVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, RubyNode valueNode) {
        super(context, sourceSection, frameSlot, valueNode);
        this.name = frameSlot.getIdentifier().toString();
    }

    public InstrumentedWriteLocalVariableNode(RubyContext context, RubySourceSection sourceSection, FrameSlot frameSlot, RubyNode valueNode) {
        super(context, sourceSection, frameSlot, valueNode);
        this.name = frameSlot.getIdentifier().toString();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = super.execute(frame);
        this.recordWrite(value);
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private void recordWrite(Object value) {
        String type = Layouts.CLASS.getFields(this.getContext().getCoreLibrary().getLogicalClass(value)).getName();
        this.getContext().getCallGraph().recordLocalWrite((RubyRootNode)this.getRootNode(), this.name, type);
    }
}

