/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.RubyMessageResolutionAccessor;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.util.StringUtils;

public class RubyObjectType
extends ObjectType {
    @CompilerDirectives.TruffleBoundary
    public String toString(DynamicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        if (RubyGuards.isRubyString(object)) {
            return RopeOperations.decodeRope(StringOperations.rope(object));
        }
        if (RubyGuards.isRubySymbol(object)) {
            return Layouts.SYMBOL.getString(object);
        }
        if (RubyGuards.isRubyException(object)) {
            return Layouts.EXCEPTION.getMessage(object).toString();
        }
        if (RubyGuards.isRubyModule(object)) {
            return Layouts.MODULE.getFields(object).getName();
        }
        return StringUtils.format("DynamicObject@%x<logicalClass=%s>", System.identityHashCode(object), Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(object)).getName());
    }

    public ForeignAccess getForeignAccessFactory(DynamicObject object) {
        return RubyMessageResolutionAccessor.ACCESS;
    }
}

