/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.mutex.ConditionVariableNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ConditionVariableNodes.class)
public final class ConditionVariableNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), WaitNodeFactory.getInstance(), SignalNodeFactory.getInstance(), BroadcastNodeFactory.getInstance(), MarshalDumpNodeFactory.getInstance());
    }

    @GeneratedBy(value=ConditionVariableNodes.MarshalDumpNode.class)
    public static final class MarshalDumpNodeFactory
    implements NodeFactory<ConditionVariableNodes.MarshalDumpNode> {
        private static MarshalDumpNodeFactory marshalDumpNodeFactoryInstance;

        private MarshalDumpNodeFactory() {
        }

        public Class<ConditionVariableNodes.MarshalDumpNode> getNodeClass() {
            return ConditionVariableNodes.MarshalDumpNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ConditionVariableNodes.MarshalDumpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MarshalDumpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.MarshalDumpNode> getInstance() {
            if (marshalDumpNodeFactoryInstance == null) {
                marshalDumpNodeFactoryInstance = new MarshalDumpNodeFactory();
            }
            return marshalDumpNodeFactoryInstance;
        }

        public static ConditionVariableNodes.MarshalDumpNode create(RubyNode[] arguments) {
            return new MarshalDumpNodeGen(arguments);
        }

        @GeneratedBy(value=ConditionVariableNodes.MarshalDumpNode.class)
        public static final class MarshalDumpNodeGen
        extends ConditionVariableNodes.MarshalDumpNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MarshalDumpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.marshal_dump(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.BroadcastNode.class)
    public static final class BroadcastNodeFactory
    implements NodeFactory<ConditionVariableNodes.BroadcastNode> {
        private static BroadcastNodeFactory broadcastNodeFactoryInstance;

        private BroadcastNodeFactory() {
        }

        public Class<ConditionVariableNodes.BroadcastNode> getNodeClass() {
            return ConditionVariableNodes.BroadcastNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public ConditionVariableNodes.BroadcastNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return BroadcastNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.BroadcastNode> getInstance() {
            if (broadcastNodeFactoryInstance == null) {
                broadcastNodeFactoryInstance = new BroadcastNodeFactory();
            }
            return broadcastNodeFactoryInstance;
        }

        public static ConditionVariableNodes.BroadcastNode create(RubyNode operand) {
            return new BroadcastNodeGen(operand);
        }

        @GeneratedBy(value=ConditionVariableNodes.BroadcastNode.class)
        public static final class BroadcastNodeGen
        extends ConditionVariableNodes.BroadcastNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BroadcastNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.doBroadcast(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.SignalNode.class)
    public static final class SignalNodeFactory
    implements NodeFactory<ConditionVariableNodes.SignalNode> {
        private static SignalNodeFactory signalNodeFactoryInstance;

        private SignalNodeFactory() {
        }

        public Class<ConditionVariableNodes.SignalNode> getNodeClass() {
            return ConditionVariableNodes.SignalNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public ConditionVariableNodes.SignalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return SignalNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.SignalNode> getInstance() {
            if (signalNodeFactoryInstance == null) {
                signalNodeFactoryInstance = new SignalNodeFactory();
            }
            return signalNodeFactoryInstance;
        }

        public static ConditionVariableNodes.SignalNode create(RubyNode operand) {
            return new SignalNodeGen(operand);
        }

        @GeneratedBy(value=ConditionVariableNodes.SignalNode.class)
        public static final class SignalNodeGen
        extends ConditionVariableNodes.SignalNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SignalNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.doSignal(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
    public static final class WaitNodeFactory
    implements NodeFactory<ConditionVariableNodes.WaitNode> {
        private static WaitNodeFactory waitNodeFactoryInstance;

        private WaitNodeFactory() {
        }

        public Class<ConditionVariableNodes.WaitNode> getNodeClass() {
            return ConditionVariableNodes.WaitNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class));
        }

        public ConditionVariableNodes.WaitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyNode) || arguments[1] != null && !(arguments[1] instanceof RubyNode) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return WaitNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]), (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.WaitNode> getInstance() {
            if (waitNodeFactoryInstance == null) {
                waitNodeFactoryInstance = new WaitNodeFactory();
            }
            return waitNodeFactoryInstance;
        }

        public static ConditionVariableNodes.WaitNode create(RubyNode conditionVariable, RubyNode mutex, RubyNode duration) {
            return new WaitNodeGen(conditionVariable, mutex, duration);
        }

        @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
        public static final class WaitNodeGen
        extends ConditionVariableNodes.WaitNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode conditionVariable_;
            @Node.Child
            private RubyNode mutex_;
            @Node.Child
            private RubyNode duration_;
            @CompilerDirectives.CompilationFinal
            private Class<?> durationType_;
            @Node.Child
            private BaseNode_ specialization_;

            private WaitNodeGen(RubyNode conditionVariable, RubyNode mutex, RubyNode duration) {
                this.conditionVariable_ = conditionVariable;
                this.mutex_ = mutex;
                this.duration_ = this.coerceDuration(duration);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="wait(DynamicObject, DynamicObject, long)", value=ConditionVariableNodes.WaitNode.class)
            private static final class WaitNode_
            extends BaseNode_ {
                private final Class<?> durationImplicitType;

                WaitNode_(WaitNodeGen root, Object durationValue) {
                    super(root, 1);
                    this.durationImplicitType = RubyTypesGen.getImplicitLongClass(durationValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.durationImplicitType == ((WaitNode_)other).durationImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    long durationValue_;
                    DynamicObject mutexValue_;
                    DynamicObject conditionVariableValue_;
                    try {
                        conditionVariableValue_ = this.root.conditionVariable_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object mutexValue = this.root.mutex_.execute(frameValue);
                        Object durationValue = this.executeDuration_((Frame)frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), mutexValue, durationValue);
                    }
                    try {
                        mutexValue_ = this.root.mutex_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object durationValue = this.executeDuration_((Frame)frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, conditionVariableValue_, ex.getResult(), durationValue);
                    }
                    try {
                        if (this.durationImplicitType == Long.TYPE) {
                            durationValue_ = this.root.duration_.executeLong(frameValue);
                        } else if (this.durationImplicitType == Integer.TYPE) {
                            durationValue_ = RubyTypes.promoteToLong(this.root.duration_.executeInteger(frameValue));
                        } else {
                            Object durationValue__ = this.executeDuration_((Frame)frameValue);
                            durationValue_ = RubyTypesGen.expectImplicitLong(durationValue__, this.durationImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, conditionVariableValue_, mutexValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyMutex(mutexValue_)) {
                        return this.root.wait(conditionVariableValue_, mutexValue_, durationValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, conditionVariableValue_, mutexValue_, durationValue_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    if (conditionVariableValue instanceof DynamicObject && mutexValue instanceof DynamicObject && RubyTypesGen.isImplicitLong(durationValue, this.durationImplicitType)) {
                        DynamicObject conditionVariableValue_ = (DynamicObject)conditionVariableValue;
                        DynamicObject mutexValue_ = (DynamicObject)mutexValue;
                        long durationValue_ = RubyTypesGen.asImplicitLong(durationValue, this.durationImplicitType);
                        if (RubyGuards.isRubyMutex(mutexValue_)) {
                            return this.root.wait(conditionVariableValue_, mutexValue_, durationValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, conditionVariableValue, mutexValue, durationValue);
                }

                static BaseNode_ create(WaitNodeGen root, Object durationValue) {
                    return new WaitNode_(root, durationValue);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(WaitNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, conditionVariableValue, mutexValue, durationValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    return this.getNext().executeDynamicObject_(frameValue, conditionVariableValue, mutexValue, durationValue);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(WaitNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, conditionVariableValue, mutexValue, durationValue);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected WaitNodeGen root;

                BaseNode_(WaitNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (WaitNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.conditionVariable_, this.root.mutex_, this.root.duration_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, conditionVariableValue, mutexValue, durationValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object conditionVariableValue_ = this.root.conditionVariable_.execute(frameValue);
                    Object mutexValue_ = this.root.mutex_.execute(frameValue);
                    Object durationValue_ = this.executeDuration_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, conditionVariableValue_, mutexValue_, durationValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object conditionVariableValue, Object mutexValue, Object durationValue) {
                    DynamicObject mutexValue_;
                    if (conditionVariableValue instanceof DynamicObject && mutexValue instanceof DynamicObject && RubyTypesGen.isImplicitLong(durationValue) && RubyGuards.isRubyMutex(mutexValue_ = (DynamicObject)mutexValue)) {
                        return WaitNode_.create(this.root, durationValue);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeDuration_(Frame frameValue) {
                    Object object;
                    Class durationType_ = this.root.durationType_;
                    if (durationType_ == Integer.TYPE) {
                        return this.root.duration_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (durationType_ == Long.TYPE) {
                        return this.root.duration_.executeLong((VirtualFrame)frameValue);
                    }
                    if (durationType_ != null) return this.root.duration_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.duration_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.durationType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.durationType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.durationType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<ConditionVariableNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<ConditionVariableNodes.AllocateNode> getNodeClass() {
            return ConditionVariableNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public ConditionVariableNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ConditionVariableNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ConditionVariableNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ConditionVariableNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

