/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class ReturnEnumeratorIfNoBlockNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode method;
    @Node.Child
    private CallDispatchHeadNode toEnumNode;
    @CompilerDirectives.CompilationFinal
    private DynamicObject methodSymbol;
    private final ConditionProfile noBlockProfile = ConditionProfile.createBinaryProfile();

    public ReturnEnumeratorIfNoBlockNode(String methodName, RubyNode method) {
        this.methodName = methodName;
        this.method = method;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject block = RubyArguments.getBlock((Frame)frame);
        if (this.noBlockProfile.profile(block == null)) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.methodSymbol == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.methodSymbol = this.getSymbol(this.methodName);
            }
            Object[] arguments = ArrayUtils.unshift(RubyArguments.getArguments((Frame)frame), this.methodSymbol);
            return this.toEnumNode.call(frame, RubyArguments.getSelf((Frame)frame), "to_enum", arguments);
        }
        return this.method.execute(frame);
    }
}

