/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;
import org.jruby.truffle.stdlib.bigdecimal.CreateBigDecimalNode;
import org.jruby.truffle.stdlib.bigdecimal.CreateBigDecimalNodeFactory;

public abstract class BigDecimalCoreMethodNode
extends CoreMethodNode {
    @Node.Child
    private CreateBigDecimalNode createBigDecimal;
    @Node.Child
    private CallDispatchHeadNode limitCall;
    @Node.Child
    private IntegerCastNode limitIntegerCast;
    @Node.Child
    private CallDispatchHeadNode roundModeCall;
    @Node.Child
    private IntegerCastNode roundModeIntegerCast;

    public static boolean isNormal(DynamicObject value) {
        return Layouts.BIG_DECIMAL.getType(value) == BigDecimalType.NORMAL;
    }

    public static boolean isNormalRubyBigDecimal(DynamicObject value) {
        return RubyGuards.isRubyBigDecimal(value) && Layouts.BIG_DECIMAL.getType(value) == BigDecimalType.NORMAL;
    }

    public static boolean isSpecialRubyBigDecimal(DynamicObject value) {
        return RubyGuards.isRubyBigDecimal(value) && Layouts.BIG_DECIMAL.getType(value) != BigDecimalType.NORMAL;
    }

    public static boolean isNormalZero(DynamicObject value) {
        return Layouts.BIG_DECIMAL.getValue(value).compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isNan(DynamicObject value) {
        return Layouts.BIG_DECIMAL.getType(value) == BigDecimalType.NAN;
    }

    protected DynamicObject createBigDecimal(VirtualFrame frame, Object value) {
        return this.getCreateBigDecimal().executeCreate(frame, value);
    }

    protected DynamicObject initializeBigDecimal(VirtualFrame frame, Object value, DynamicObject self, Object digits) {
        return this.getCreateBigDecimal().executeInitialize(frame, value, self, digits);
    }

    protected RoundingMode getRoundMode(VirtualFrame frame) {
        return BigDecimalCoreMethodNode.toRoundingMode(this.getRoundModeIntegerCast().executeCastInt(this.getRoundModeCall().call(frame, this.getBigDecimalClass(), "mode", 256)));
    }

    protected DynamicObject getBigDecimalClass() {
        return this.coreLibrary().getBigDecimalClass();
    }

    protected static RoundingMode toRoundingMode(int constValue) {
        switch (constValue) {
            case 1: {
                return RoundingMode.UP;
            }
            case 2: {
                return RoundingMode.DOWN;
            }
            case 3: {
                return RoundingMode.HALF_UP;
            }
            case 4: {
                return RoundingMode.HALF_DOWN;
            }
            case 5: {
                return RoundingMode.CEILING;
            }
            case 6: {
                return RoundingMode.FLOOR;
            }
            case 7: {
                return RoundingMode.HALF_EVEN;
            }
        }
        throw new UnsupportedOperationException("unknown value: " + constValue);
    }

    protected static int nearestBiggerMultipleOf4(int value) {
        return (value / 4 + 1) * 4;
    }

    protected static int defaultDivisionPrecision(int precisionA, int precisionB, int limit) {
        int combination = BigDecimalCoreMethodNode.nearestBiggerMultipleOf4(precisionA + precisionB) * 4;
        return limit > 0 && limit < combination ? limit : combination;
    }

    protected static int defaultDivisionPrecision(BigDecimal a, BigDecimal b, int limit) {
        return BigDecimalCoreMethodNode.defaultDivisionPrecision(a.precision(), b.precision(), limit);
    }

    protected int getLimit(VirtualFrame frame) {
        return this.getLimitIntegerCast().executeCastInt(this.getLimitCall().call(frame, this.getBigDecimalClass(), "limit", new Object[0]));
    }

    private CreateBigDecimalNode getCreateBigDecimal() {
        if (this.createBigDecimal == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.createBigDecimal = (CreateBigDecimalNode)this.insert(CreateBigDecimalNodeFactory.create(null, null, null));
        }
        return this.createBigDecimal;
    }

    private CallDispatchHeadNode getLimitCall() {
        if (this.limitCall == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.limitCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        return this.limitCall;
    }

    private IntegerCastNode getLimitIntegerCast() {
        if (this.limitIntegerCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.limitIntegerCast = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.limitIntegerCast;
    }

    private CallDispatchHeadNode getRoundModeCall() {
        if (this.roundModeCall == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.roundModeCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        return this.roundModeCall;
    }

    private IntegerCastNode getRoundModeIntegerCast() {
        if (this.roundModeIntegerCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.roundModeIntegerCast = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.roundModeIntegerCast;
    }
}

