/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.ast.NilNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.RaiseException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.LoadRequiredLibrariesNode;
import org.jruby.truffle.core.SetTopLevelBindingNode;
import org.jruby.truffle.language.DataNode;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.exceptions.TopLevelRaiseHandler;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.CatchNextNode;
import org.jruby.truffle.language.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.language.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.parser.Parser;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.language.parser.jruby.BodyTranslator;
import org.jruby.truffle.language.parser.jruby.ParseEnvironment;
import org.jruby.truffle.language.parser.jruby.Translator;
import org.jruby.truffle.language.parser.jruby.TranslatorEnvironment;

public class TranslatorDriver
implements Parser {
    private final ParseEnvironment parseEnvironment;

    public TranslatorDriver(RubyContext context) {
        this.parseEnvironment = new ParseEnvironment(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyRootNode parse(RubyContext context, Source source, Encoding defaultEncoding, ParserContext parserContext, String[] argumentNames, FrameDescriptor frameDescriptor, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        RubyNode truffleNode;
        RootNode node;
        TranslatorEnvironment parentEnvironment;
        org.jruby.parser.Parser parser = new org.jruby.parser.Parser(context.getJRubyRuntime());
        StaticScope staticScope = context.getJRubyRuntime().getStaticScopeFactory().newLocalScope(null);
        if (frameDescriptor != null) {
            for (Object slot : frameDescriptor.getSlots()) {
                if (!(slot.getIdentifier() instanceof String)) continue;
                String name = (String)slot.getIdentifier();
                staticScope.addVariableThisScope(name.intern());
            }
            parentEnvironment = this.environmentForFrameDescriptor(context, frameDescriptor);
        } else if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    if (!(slot.getIdentifier() instanceof String)) continue;
                    Object name = (String)slot.getIdentifier();
                    staticScope.addVariableThisScope(((String)name).intern());
                }
                frame = RubyArguments.getDeclarationFrame((Frame)frame);
            }
            parentEnvironment = this.environmentForFrame(context, parentFrame);
        } else {
            parentEnvironment = this.environmentForFrame(context, null);
        }
        if (argumentNames != null) {
            for (Object name : argumentNames) {
                staticScope.addVariableThisScope(((String)name).intern());
            }
        }
        ManyVarsDynamicScope dynamicScope = new ManyVarsDynamicScope(staticScope);
        boolean isInlineSource = parserContext == ParserContext.SHELL;
        boolean isEvalParse = parserContext == ParserContext.EVAL || parserContext == ParserContext.INLINE || parserContext == ParserContext.MODULE;
        ParserConfiguration parserConfiguration = new ParserConfiguration(context.getJRubyRuntime(), 0, isInlineSource, !isEvalParse, false);
        if (context.getJRubyRuntime().getInstanceConfig().isFrozenStringLiteral()) {
            parserConfiguration.setFrozenStringLiteral(true);
        }
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        try {
            node = (RootNode)parser.parse(source.getName(), source.getCode().getBytes(StandardCharsets.UTF_8), (DynamicScope)dynamicScope, parserConfiguration);
        }
        catch (RaiseException e) {
            String message = e.getException().getMessage().asJavaString();
            if (message == null) {
                message = "(no message)";
            }
            throw new org.jruby.truffle.language.control.RaiseException(context.getCoreExceptions().syntaxError(message, currentNode));
        }
        String identifier = "<main>";
        SourceSection sourceSection = source.createSection("<main>", 0, source.getCode().length());
        InternalMethod parentMethod = parentFrame == null ? null : RubyArguments.getMethod((Frame)parentFrame);
        LexicalScope lexicalScope = parentMethod != null && parentMethod.getSharedMethodInfo().getLexicalScope() != null ? parentMethod.getSharedMethodInfo().getLexicalScope() : context.getRootLexicalScope();
        if (parserContext == ParserContext.MODULE) {
            Object module = RubyArguments.getSelf(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            lexicalScope = new LexicalScope(lexicalScope, (DynamicObject)module);
        }
        this.parseEnvironment.resetLexicalScope(lexicalScope);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.parseEnvironment.getLexicalScope(), Arity.NO_ARGUMENTS, "<main>", false, null, false, false, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, parentEnvironment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), ownScopeForAssignments, false, sharedMethodInfo, sharedMethodInfo.getName(), 0, null);
        if (argumentNames != null) {
            for (MaterializedFrame name : argumentNames) {
                environment.declareVar((String)name);
            }
        }
        BodyTranslator translator = new BodyTranslator(currentNode, context, null, environment, source, parserContext == ParserContext.TOP_LEVEL_FIRST || parserContext == ParserContext.TOP_LEVEL);
        if (node.getBodyNode() == null || node.getBodyNode() instanceof NilNode) {
            translator.parentSourceSection.push(sourceSection);
            try {
                truffleNode = translator.nilNode(sourceSection);
            }
            finally {
                translator.parentSourceSection.pop();
            }
        } else {
            truffleNode = (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)translator));
        }
        if (argumentNames != null && ((MaterializedFrame)argumentNames).length > 0) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            for (int n = 0; n < ((MaterializedFrame)argumentNames).length; ++n) {
                MaterializedFrame name = argumentNames[n];
                ReadPreArgumentNode readNode = new ReadPreArgumentNode(n, MissingArgumentBehavior.NIL);
                FrameSlot slot = environment.getFrameDescriptor().findFrameSlot((Object)name);
                sequence.add(WriteLocalVariableNode.createWriteLocalVariableNode(context, sourceSection, slot, readNode));
            }
            sequence.add(truffleNode);
            truffleNode = Translator.sequence(context, "<main>", sourceSection, sequence);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = Translator.sequence(context, "<main>", truffleNode.getSourceSection(), Arrays.asList(translator.initFlipFlopStates(truffleNode.getSourceSection()), truffleNode));
        }
        truffleNode = new CatchNextNode(context, truffleNode.getSourceSection(), truffleNode);
        if (parserContext != ParserContext.INLINE) {
            truffleNode = new CatchReturnAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        }
        truffleNode = new CatchRetryAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        if (parserContext == ParserContext.TOP_LEVEL_FIRST) {
            truffleNode = Translator.sequence(context, "<main>", sourceSection, Arrays.asList(new RubyNode[]{new SetTopLevelBindingNode(context, sourceSection), new LoadRequiredLibrariesNode(context, sourceSection), truffleNode}));
            if (node.hasEndPosition()) {
                truffleNode = Translator.sequence(context, "<main>", sourceSection, Arrays.asList(new RubyNode[]{new DataNode(context, sourceSection, node.getEndPosition()), truffleNode}));
            }
            truffleNode = new TopLevelRaiseHandler(context, sourceSection, truffleNode);
        }
        return new RubyRootNode(context, truffleNode.getSourceSection(), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode, environment.needsDeclarationFrame());
    }

    private TranslatorEnvironment environmentForFrameDescriptor(RubyContext context, FrameDescriptor frameDescriptor) {
        SourceSection sourceSection = SourceSection.createUnavailable((String)"Unknown source section", (String)"(unknown)");
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false, false, false);
        return new TranslatorEnvironment(context, null, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frameDescriptor);
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        SourceSection sourceSection = SourceSection.createUnavailable((String)"Unknown source section", (String)"(unknown)");
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false, false, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame((Frame)frame);
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frame.getFrameDescriptor());
    }
}

