/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;

@GeneratedBy(value=TaintNode.class)
public final class TaintNodeGen
extends TaintNode
implements SpecializedNode {
    @Node.Child
    private RubyNode child_;
    @CompilerDirectives.CompilationFinal
    private Class<?> childType_;
    @Node.Child
    private BaseNode_ specialization_;

    private TaintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child_ = child;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeTaint(Object childValue) {
        return this.specialization_.execute1(childValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static TaintNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return new TaintNodeGen(context, sourceSection, child);
    }

    @GeneratedBy(methodName="taint(DynamicObject, WriteObjectFieldNode)", value=TaintNode.class)
    private static final class Taint4Node_
    extends BaseNode_ {
        @Node.Child
        private WriteObjectFieldNode writeTaintNode;

        Taint4Node_(TaintNodeGen root, WriteObjectFieldNode writeTaintNode) {
            super(root, 6);
            this.writeTaintNode = writeTaintNode;
        }

        @Override
        public Object execute1(Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && !RubyGuards.isRubySymbol(childValue_ = (DynamicObject)childValue) && !this.root.isNil(childValue_)) {
                return this.root.taint(childValue_, this.writeTaintNode);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root, WriteObjectFieldNode writeTaintNode) {
            return new Taint4Node_(root, writeTaintNode);
        }
    }

    @GeneratedBy(methodName="taintNilOrSymbol(DynamicObject)", value=TaintNode.class)
    private static final class TaintNilOrSymbolNode_
    extends BaseNode_ {
        TaintNilOrSymbolNode_(TaintNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute1(Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && (RubyGuards.isRubySymbol(childValue_ = (DynamicObject)childValue) || this.root.isNil(childValue_))) {
                return this.root.taintNilOrSymbol(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root) {
            return new TaintNilOrSymbolNode_(root);
        }
    }

    @GeneratedBy(methodName="taint(double)", value=TaintNode.class)
    private static final class Taint3Node_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        Taint3Node_(TaintNodeGen root, Object childValue) {
            super(root, 4);
            this.childImplicitType = RubyTypesGen.getImplicitDoubleClass(childValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((Taint3Node_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            double childValue_;
            try {
                if (this.childImplicitType == Double.TYPE) {
                    childValue_ = this.root.child_.executeDouble(frameValue);
                } else {
                    Object childValue__ = this.executeChild_((Frame)frameValue);
                    childValue_ = RubyTypesGen.expectImplicitDouble(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.taint(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (RubyTypesGen.isImplicitDouble(childValue, this.childImplicitType)) {
                double childValue_ = RubyTypesGen.asImplicitDouble(childValue, this.childImplicitType);
                return this.root.taint(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root, Object childValue) {
            return new Taint3Node_(root, childValue);
        }
    }

    @GeneratedBy(methodName="taint(long)", value=TaintNode.class)
    private static final class Taint2Node_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        Taint2Node_(TaintNodeGen root, Object childValue) {
            super(root, 3);
            this.childImplicitType = RubyTypesGen.getImplicitLongClass(childValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((Taint2Node_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            long childValue_;
            try {
                if (this.childImplicitType == Long.TYPE) {
                    childValue_ = this.root.child_.executeLong(frameValue);
                } else if (this.childImplicitType == Integer.TYPE) {
                    childValue_ = RubyTypes.promoteToLong(this.root.child_.executeInteger(frameValue));
                } else {
                    Object childValue__ = this.executeChild_((Frame)frameValue);
                    childValue_ = RubyTypesGen.expectImplicitLong(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.taint(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (RubyTypesGen.isImplicitLong(childValue, this.childImplicitType)) {
                long childValue_ = RubyTypesGen.asImplicitLong(childValue, this.childImplicitType);
                return this.root.taint(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root, Object childValue) {
            return new Taint2Node_(root, childValue);
        }
    }

    @GeneratedBy(methodName="taint(int)", value=TaintNode.class)
    private static final class Taint1Node_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        Taint1Node_(TaintNodeGen root, Object childValue) {
            super(root, 2);
            this.childImplicitType = RubyTypesGen.getImplicitIntegerClass(childValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((Taint1Node_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int childValue_;
            try {
                if (this.childImplicitType == Integer.TYPE) {
                    childValue_ = this.root.child_.executeInteger(frameValue);
                } else {
                    Object childValue__ = this.executeChild_((Frame)frameValue);
                    childValue_ = RubyTypesGen.expectImplicitInteger(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.taint(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (RubyTypesGen.isImplicitInteger(childValue, this.childImplicitType)) {
                int childValue_ = RubyTypesGen.asImplicitInteger(childValue, this.childImplicitType);
                return this.root.taint(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root, Object childValue) {
            return new Taint1Node_(root, childValue);
        }
    }

    @GeneratedBy(methodName="taint(boolean)", value=TaintNode.class)
    private static final class Taint0Node_
    extends BaseNode_ {
        Taint0Node_(TaintNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean childValue_;
            try {
                childValue_ = this.root.child_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.taint(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (childValue instanceof Boolean) {
                boolean childValue_ = (Boolean)childValue;
                return this.root.taint(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root) {
            return new Taint0Node_(root);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(TaintNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object childValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, childValue));
        }

        @Override
        public Object execute1(Object childValue) {
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(TaintNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(TaintNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute1(Object childValue) {
            return this.uninitialized(null, childValue);
        }

        static BaseNode_ create(TaintNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected TaintNodeGen root;

        BaseNode_(TaintNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (TaintNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.child_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object childValue) {
            return this.execute1(childValue);
        }

        public abstract Object execute1(Object var1);

        public Object execute0(VirtualFrame frameValue) {
            Object childValue_ = this.executeChild_((Frame)frameValue);
            return this.execute1(childValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object childValue) {
            if (childValue instanceof Boolean) {
                return Taint0Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(childValue)) {
                return Taint1Node_.create(this.root, childValue);
            }
            if (RubyTypesGen.isImplicitLong(childValue)) {
                return Taint2Node_.create(this.root, childValue);
            }
            if (RubyTypesGen.isImplicitDouble(childValue)) {
                return Taint3Node_.create(this.root, childValue);
            }
            if (childValue instanceof DynamicObject) {
                DynamicObject childValue_ = (DynamicObject)childValue;
                if (RubyGuards.isRubySymbol(childValue_) || this.root.isNil(childValue_)) {
                    return TaintNilOrSymbolNode_.create(this.root);
                }
                if (!RubyGuards.isRubySymbol(childValue_) && !this.root.isNil(childValue_)) {
                    WriteObjectFieldNode writeTaintNode6 = this.root.createWriteTaintNode();
                    return Taint4Node_.create(this.root, writeTaintNode6);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeChild_(Frame frameValue) {
            Object object;
            Class childType_ = this.root.childType_;
            if (childType_ == Boolean.TYPE) {
                return this.root.child_.executeBoolean((VirtualFrame)frameValue);
            }
            if (childType_ == Double.TYPE) {
                return this.root.child_.executeDouble((VirtualFrame)frameValue);
            }
            if (childType_ == Integer.TYPE) {
                return this.root.child_.executeInteger((VirtualFrame)frameValue);
            }
            if (childType_ == Long.TYPE) {
                return this.root.child_.executeLong((VirtualFrame)frameValue);
            }
            if (childType_ != null) return this.root.child_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.child_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.childType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.childType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.childType_ = _type;
            return object;
        }
    }
}

