/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.exceptions.SetExceptionVariableNode;

public class EnsureNode
extends RubyNode {
    @Node.Child
    private RubyNode tryPart;
    @Node.Child
    private RubyNode ensurePart;
    @Node.Child
    private SetExceptionVariableNode setExceptionVariableNode;
    private final BranchProfile rubyExceptionPath = BranchProfile.create();
    private final BranchProfile javaExceptionPath = BranchProfile.create();

    public EnsureNode(RubyContext context, SourceSection sourceSection, RubyNode tryPart, RubyNode ensurePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.ensurePart = ensurePart;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value;
        try {
            value = this.tryPart.execute(frame);
        }
        catch (RaiseException exception) {
            this.rubyExceptionPath.enter();
            this.setLastExceptionAndRunEnsure(frame, exception);
            throw exception;
        }
        catch (Throwable throwable) {
            this.javaExceptionPath.enter();
            this.ensurePart.executeVoid(frame);
            throw throwable;
        }
        this.ensurePart.executeVoid(frame);
        return value;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        try {
            this.tryPart.executeVoid(frame);
        }
        catch (RaiseException exception) {
            this.rubyExceptionPath.enter();
            this.setLastExceptionAndRunEnsure(frame, exception);
            throw exception;
        }
        catch (Throwable throwable) {
            this.javaExceptionPath.enter();
            this.ensurePart.executeVoid(frame);
            throw throwable;
        }
        this.ensurePart.executeVoid(frame);
    }

    private void setLastExceptionAndRunEnsure(VirtualFrame frame, RaiseException exception) {
        if (this.setExceptionVariableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setExceptionVariableNode = (SetExceptionVariableNode)this.insert(new SetExceptionVariableNode(this.getContext()));
        }
        this.setExceptionVariableNode.setLastExceptionAndRun(frame, exception, this.ensurePart);
    }
}

