/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.LookupConstantNode;

@GeneratedBy(value=LookupConstantNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class LookupConstantNodeGen
extends LookupConstantNode
implements SpecializedNode {
    @Node.Child
    private RubyNode module_;
    @Node.Child
    private RubyNode name_;
    @Node.Child
    private BaseNode_ specialization_;

    private LookupConstantNodeGen(boolean ignoreVisibility, boolean lookInObject, RubyNode module, RubyNode name) {
        super(ignoreVisibility, lookInObject);
        this.module_ = module;
        this.name_ = name;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public RubyConstant executeLookupConstant(VirtualFrame frameValue, Object moduleValue, String nameValue) {
        return this.specialization_.executeRubyConstant(frameValue, moduleValue, nameValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static LookupConstantNode create(boolean ignoreVisibility, boolean lookInObject, RubyNode module, RubyNode name) {
        return new LookupConstantNodeGen(ignoreVisibility, lookInObject, module, name);
    }

    @GeneratedBy(methodName="lookupNotModule(Object, String)", value=LookupConstantNode.class)
    private static final class LookupNotModuleNode_
    extends BaseNode_ {
        LookupNotModuleNode_(LookupConstantNodeGen root) {
            super(root, 3);
        }

        @Override
        public RubyConstant executeRubyConstant(VirtualFrame frameValue, Object moduleValue, String nameValue) {
            if (!RubyGuards.isRubyModule(moduleValue)) {
                return this.root.lookupNotModule(moduleValue, nameValue);
            }
            return this.getNext().executeRubyConstant(frameValue, moduleValue, nameValue);
        }

        @Override
        public RubyConstant executeRubyConstant_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            if (nameValue instanceof String) {
                String nameValue_ = (String)nameValue;
                if (!RubyGuards.isRubyModule(moduleValue)) {
                    return this.root.lookupNotModule(moduleValue, nameValue_);
                }
            }
            return this.getNext().executeRubyConstant_(frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(LookupConstantNodeGen root) {
            return new LookupNotModuleNode_(root);
        }
    }

    @GeneratedBy(methodName="lookupConstantUncached(DynamicObject, String)", value=LookupConstantNode.class)
    private static final class LookupConstantUncachedNode_
    extends BaseNode_ {
        LookupConstantUncachedNode_(LookupConstantNodeGen root) {
            super(root, 2);
        }

        @Override
        public RubyConstant executeRubyConstant(VirtualFrame frameValue, Object moduleValue, String nameValue) {
            DynamicObject moduleValue_;
            if (moduleValue instanceof DynamicObject && RubyGuards.isRubyModule(moduleValue_ = (DynamicObject)moduleValue)) {
                return this.root.lookupConstantUncached(moduleValue_, nameValue);
            }
            return this.getNext().executeRubyConstant(frameValue, moduleValue, nameValue);
        }

        @Override
        public RubyConstant executeRubyConstant_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            if (moduleValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                String nameValue_ = (String)nameValue;
                if (RubyGuards.isRubyModule(moduleValue_)) {
                    return this.root.lookupConstantUncached(moduleValue_, nameValue_);
                }
            }
            return this.getNext().executeRubyConstant_(frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(LookupConstantNodeGen root) {
            return new LookupConstantUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="lookupConstant(VirtualFrame, DynamicObject, String, DynamicObject, String, RubyConstant, boolean, ConditionProfile)", value=LookupConstantNode.class)
    private static final class LookupConstantNode_
    extends BaseNode_ {
        private final DynamicObject cachedModule;
        private final String cachedName;
        private final RubyConstant constant;
        private final boolean isVisible;
        private final ConditionProfile sameNameProfile;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        LookupConstantNode_(LookupConstantNodeGen root, DynamicObject cachedModule, String cachedName, RubyConstant constant, boolean isVisible, ConditionProfile sameNameProfile, Assumption assumption0_) {
            super(root, 1);
            this.cachedModule = cachedModule;
            this.cachedName = cachedName;
            this.constant = constant;
            this.isVisible = isVisible;
            this.sameNameProfile = sameNameProfile;
            this.assumption0_ = assumption0_;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object moduleValue, Object nameValue) {
            if (moduleValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                String nameValue_ = (String)nameValue;
                if (moduleValue_ == this.cachedModule && this.root.guardName(nameValue_, this.cachedName, this.sameNameProfile)) {
                    assert (RubyGuards.isRubyModule(this.cachedModule));
                    return true;
                }
            }
            return false;
        }

        @Override
        public RubyConstant executeRubyConstant(VirtualFrame frameValue, Object moduleValue, String nameValue) {
            DynamicObject moduleValue_;
            try {
                LookupConstantNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (RubyConstant)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, moduleValue, nameValue);
            }
            if (moduleValue instanceof DynamicObject && (moduleValue_ = (DynamicObject)moduleValue) == this.cachedModule && this.root.guardName(nameValue, this.cachedName, this.sameNameProfile)) {
                assert (RubyGuards.isRubyModule(this.cachedModule));
                return this.root.lookupConstant(frameValue, moduleValue_, nameValue, this.cachedModule, this.cachedName, this.constant, this.isVisible, this.sameNameProfile);
            }
            return this.getNext().executeRubyConstant(frameValue, moduleValue, nameValue);
        }

        @Override
        public RubyConstant executeRubyConstant_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            try {
                LookupConstantNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (RubyConstant)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, moduleValue, nameValue);
            }
            if (moduleValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                String nameValue_ = (String)nameValue;
                if (moduleValue_ == this.cachedModule && this.root.guardName(nameValue_, this.cachedName, this.sameNameProfile)) {
                    assert (RubyGuards.isRubyModule(this.cachedModule));
                    return this.root.lookupConstant(frameValue, moduleValue_, nameValue_, this.cachedModule, this.cachedName, this.constant, this.isVisible, this.sameNameProfile);
                }
            }
            return this.getNext().executeRubyConstant_(frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(LookupConstantNodeGen root, DynamicObject cachedModule, String cachedName, RubyConstant constant, boolean isVisible, ConditionProfile sameNameProfile, Assumption assumption0_) {
            return new LookupConstantNode_(root, cachedModule, cachedName, constant, isVisible, sameNameProfile, assumption0_);
        }
    }

    @GeneratedBy(value=LookupConstantNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(LookupConstantNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object moduleValue, Object nameValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, moduleValue, nameValue));
        }

        @Override
        public RubyConstant executeRubyConstant_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            return this.getNext().executeRubyConstant_(frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(LookupConstantNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=LookupConstantNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(LookupConstantNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public RubyConstant executeRubyConstant_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            return (RubyConstant)this.uninitialized((Frame)frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(LookupConstantNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=LookupConstantNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected LookupConstantNodeGen root;

        BaseNode_(LookupConstantNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (LookupConstantNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.module_, this.root.name_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object moduleValue, Object nameValue) {
            return this.executeRubyConstant_((VirtualFrame)frameValue, moduleValue, nameValue);
        }

        public abstract RubyConstant executeRubyConstant_(VirtualFrame var1, Object var2, Object var3);

        public RubyConstant executeRubyConstant(VirtualFrame frameValue, Object moduleValue, String nameValue) {
            return this.executeRubyConstant_(frameValue, moduleValue, nameValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object moduleValue_ = this.root.module_.execute(frameValue);
            Object nameValue_ = this.root.name_.execute(frameValue);
            return this.executeRubyConstant_(frameValue, moduleValue_, nameValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object moduleValue, Object nameValue) {
            if (nameValue instanceof String) {
                String nameValue_ = (String)nameValue;
                if (moduleValue instanceof DynamicObject) {
                    DynamicObject moduleValue_;
                    DynamicObject cachedModule1 = moduleValue_ = (DynamicObject)moduleValue;
                    String cachedName1 = nameValue_;
                    ConditionProfile sameNameProfile1 = ConditionProfile.createBinaryProfile();
                    if (moduleValue_ == cachedModule1 && RubyGuards.isRubyModule(cachedModule1) && this.root.guardName(nameValue_, cachedName1, sameNameProfile1)) {
                        BaseNode_ s;
                        RubyConstant constant1 = this.root.doLookup(cachedModule1, cachedName1);
                        boolean isVisible1 = this.root.isVisible(cachedModule1, constant1);
                        Assumption assumption0_1 = this.root.getUnmodifiedAssumption(cachedModule1);
                        if (BaseNode_.isValid((Assumption)assumption0_1) && this.countSame(s = LookupConstantNode_.create(this.root, cachedModule1, cachedName1, constant1, isVisible1, sameNameProfile1, assumption0_1)) < this.root.getCacheLimit()) {
                            return s;
                        }
                    }
                    if (RubyGuards.isRubyModule(moduleValue_)) {
                        return LookupConstantUncachedNode_.create(this.root);
                    }
                }
                if (!RubyGuards.isRubyModule(moduleValue)) {
                    return LookupNotModuleNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

