/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.PrimitiveNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.core.cast.ArrayAttributeCastNodeGen;
import org.jruby.truffle.core.cast.CmpIntNode;
import org.jruby.truffle.core.cast.CmpIntNodeGen;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingNodesFactory;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.format.FormatExceptionTranslator;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.unpack.ArrayResult;
import org.jruby.truffle.core.format.unpack.UnpackCompiler;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.core.string.ConvertBytes;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringCodeRangeableWrapper;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.CheckLayoutNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.platform.posix.TrufflePosix;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertDouble;
import org.jruby.util.StringSupport;

@CoreClass(value="String")
public abstract class StringNodes {

    @Primitive(name="string_from_bytearray", needsSelf=false, lowerFixnum={2, 3})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubiniusByteArray(bytes)"})
        public DynamicObject stringFromByteArray(DynamicObject bytes, int start, int count) {
            ByteList byteList = Layouts.BYTE_ARRAY.getBytes(bytes);
            return this.createString(new ByteList(byteList, start, count));
        }
    }

    @Primitive(name="string_substring", lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public abstract Object execute(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"!indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstring(DynamicObject string, int beg, int len, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile stillNegativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile tooLargeTotalProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile, @Cached(value="createBinaryProfile()") ConditionProfile foundSingleByteOptimizableDescendentProfile) {
            Rope rope = StringOperations.rope(string);
            int index = beg;
            int length = len;
            if (negativeIndexProfile.profile(index < 0) && stillNegativeIndexProfile.profile((index += rope.characterLength()) < 0)) {
                return this.nil();
            }
            if (tooLargeTotalProfile.profile(index + length > rope.characterLength())) {
                length = rope.characterLength() - index;
            }
            if (singleByteOptimizableProfile.profile(length == 0 || rope.isSingleByteOptimizable())) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    return this.makeBuffer(string, index, length);
                }
                return this.makeRope(string, rope, index, length);
            }
            SearchResult searchResult = this.searchForSingleByteOptimizableDescendant(rope, index, length);
            if (foundSingleByteOptimizableDescendentProfile.profile(searchResult.rope.isSingleByteOptimizable())) {
                return this.makeRope(string, searchResult.rope, searchResult.index, length);
            }
            return this.stringSubstringMultitByte(string, index, length);
        }

        @CompilerDirectives.TruffleBoundary
        private SearchResult searchForSingleByteOptimizableDescendant(Rope base, int index, int length) {
            if (base.isSingleByteOptimizable()) {
                return new SearchResult(index, base);
            }
            if (base instanceof LeafRope) {
                return new SearchResult(index, base);
            }
            if (base instanceof SubstringRope) {
                SubstringRope substringRope = (SubstringRope)base;
                return this.searchForSingleByteOptimizableDescendant(substringRope.getChild(), index + substringRope.getOffset(), length);
            }
            if (base instanceof ConcatRope) {
                ConcatRope concatRope = (ConcatRope)base;
                Rope left = concatRope.getLeft();
                Rope right = concatRope.getRight();
                if (index < left.byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(left, index, length);
                }
                if (index >= left.byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(right, index - left.byteLength(), length);
                }
                return new SearchResult(index, concatRope);
            }
            if (base instanceof RepeatingRope) {
                RepeatingRope repeatingRope = (RepeatingRope)base;
                if (index + length < repeatingRope.getChild().byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(repeatingRope.getChild(), index, length);
                }
                return new SearchResult(index, repeatingRope);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("Don't know how to traverse rope type: " + base.getClass().getName());
        }

        @CompilerDirectives.TruffleBoundary
        private Object stringSubstringMultitByte(DynamicObject string, int beg, int len) {
            int p;
            Rope rope = StringOperations.rope(string);
            int length = rope.byteLength();
            boolean isMutableRope = rope instanceof RopeBuffer;
            Encoding enc = rope.getEncoding();
            int s = 0;
            int end = s + length;
            byte[] bytes = rope.getBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    if (isMutableRope) {
                        return this.makeBuffer(string, p2 - s, e - p2);
                    }
                    return this.makeRope(string, rope, p2 - s, e - p2);
                }
                if ((beg += rope.characterLength()) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > rope.characterLength()) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (StringOperations.isCodeRangeValid(string) && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth((byte[])bytes, (int)s, (int)end, (int)beg);
                len = StringSupport.utf8Offset((byte[])bytes, (int)p, (int)end, (int)len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth((Encoding)enc, (byte[])bytes, (int)s, (int)end, (int)beg);
                len = p == end ? 0 : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)len);
            }
            if (isMutableRope) {
                return this.makeBuffer(string, p - s, len);
            }
            return this.makeRope(string, rope, p - s, len);
        }

        @Specialization(guards={"indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstringNegativeLength(DynamicObject string, int beg, int len) {
            return this.nil();
        }

        protected static boolean indexTriviallyOutOfBounds(DynamicObject string, int index, int length) {
            assert (RubyGuards.isRubyString(string));
            return length < 0 || index > StringOperations.rope(string).characterLength();
        }

        private DynamicObject makeRope(DynamicObject string, Rope rope, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateNode = (AllocateObjectNode)this.insert(AllocateObjectNode.create());
            }
            if (this.makeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.makeSubstringNode = (RopeNodes.MakeSubstringNode)this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, beg, len));
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }

        private DynamicObject makeBuffer(DynamicObject string, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            RopeBuffer buffer = (RopeBuffer)StringOperations.rope(string);
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateNode = (AllocateObjectNode)this.insert(AllocateObjectNode.create());
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new RopeBuffer(new ByteList(buffer.getByteList(), beg, len), buffer.getCodeRange(), buffer.isSingleByteOptimizable(), len));
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }

        private final class SearchResult {
            public final int index;
            public final Rope rope;

            public SearchResult(int index, Rope rope) {
                this.index = index;
                this.rope = rope;
            }
        }
    }

    @Primitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public StringByteAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringByteAppend(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            LeafRope rightConverted = this.makeLeafRopeNode.executeMake(right.getBytes(), left.getEncoding(), left.getCodeRange(), NotProvided.INSTANCE);
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, rightConverted, left.getEncoding()));
            return string;
        }
    }

    @Primitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToInum(DynamicObject string, int fixBase, boolean strict, @Cached(value="create(getContext(), getSourceSection())") FixnumOrBignumNode fixnumOrBignumNode) {
            return ConvertBytes.byteListToInum19(this.getContext(), this, fixnumOrBignumNode, string, fixBase, strict);
        }
    }

    @Primitive(name="string_splice", needsSelf=false, lowerFixnum={3, 4})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSplicePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode appendMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode prependMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode leftMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode rightMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode prependMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode;

        @Specialization(guards={"indexAtStartBound(spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object splicePrepend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            if (this.prependMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.prependMakeSubstringNode = (RopeNodes.MakeSubstringNode)this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.prependMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.prependMakeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope original = StringOperations.rope(string);
            Rope left = StringOperations.rope(other);
            Rope right = this.prependMakeSubstringNode.executeMake(original, byteCountToReplace, original.byteLength() - byteCountToReplace);
            StringOperations.setRope(string, this.prependMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"indexAtEndBound(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object spliceAppend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            if (this.appendMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendMakeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.appendMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "!isRopeBuffer(string)"})
        public DynamicObject splice(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile insertStringIsEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile splitRightIsEmptyProfile) {
            if (this.leftMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.leftMakeSubstringNode = (RopeNodes.MakeSubstringNode)this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.rightMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rightMakeSubstringNode = (RopeNodes.MakeSubstringNode)this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.leftMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.leftMakeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            if (this.rightMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rightMakeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope source = StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            Rope splitLeft = this.leftMakeSubstringNode.executeMake(source, 0, spliceByteIndex);
            Rope splitRight = this.rightMakeSubstringNode.executeMake(source, rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            Rope joinedLeft = insertStringIsEmptyProfile.profile(insert.isEmpty()) ? splitLeft : this.leftMakeConcatNode.executeMake(splitLeft, insert, encoding);
            Rope joinedRight = splitRightIsEmptyProfile.profile(splitRight.isEmpty()) ? joinedLeft : this.rightMakeConcatNode.executeMake(joinedLeft, splitRight, encoding);
            StringOperations.setRope(string, joinedRight);
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "isRopeBuffer(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject spliceBuffer(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile sameCodeRangeProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            RopeBuffer source = (RopeBuffer)StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            ByteList byteList = new ByteList(source.byteLength() + insert.byteLength() - byteCountToReplace);
            byteList.append(source.getByteList(), 0, spliceByteIndex);
            byteList.append(insert.getBytes());
            byteList.append(source.getByteList(), rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            byteList.setEncoding(encoding);
            RopeBuffer buffer = new RopeBuffer(byteList, RopeNodes.MakeConcatNode.commonCodeRange(source.getCodeRange(), insert.getCodeRange(), sameCodeRangeProfile, brokenCodeRangeProfile), source.isSingleByteOptimizable() && insert.isSingleByteOptimizable(), source.characterLength() + insert.characterLength() - byteCountToReplace);
            StringOperations.setRope(string, buffer);
            return string;
        }

        protected boolean indexAtStartBound(int index) {
            return index == 0;
        }

        protected boolean indexAtEndBound(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return index == StringOperations.rope(string).byteLength();
        }

        protected boolean indexAtEitherBounds(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return this.indexAtStartBound(index) || this.indexAtEndBound(string, index);
        }

        protected boolean isRopeBuffer(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string) instanceof RopeBuffer;
        }
    }

    @Primitive(name="string_pattern", lowerFixnum={1, 2})
    public static abstract class StringPatternPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodes.MakeLeafRopeNode.create();
        @Node.Child
        private RopeNodes.MakeRepeatingNode makeRepeatingNode = RopeNodes.MakeRepeatingNode.create();

        public StringPatternPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"value >= 0"})
        public DynamicObject stringPatternZero(DynamicObject stringClass, int size, int value) {
            Rope repeatingRope = this.makeRepeatingNode.executeMake(RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[value], size);
            return this.allocateObjectNode.allocate(stringClass, repeatingRope);
        }

        @Specialization(guards={"isRubyString(string)", "patternFitsEvenly(string, size)"})
        public DynamicObject stringPatternFitsEvenly(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Rope repeatingRope = this.makeRepeatingNode.executeMake(rope, size / rope.byteLength());
            return this.allocateObjectNode.allocate(stringClass, repeatingRope);
        }

        @Specialization(guards={"isRubyString(string)", "!patternFitsEvenly(string, size)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject stringPattern(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = new byte[size];
            if (!rope.isEmpty()) {
                for (int n = 0; n < size; n += rope.byteLength()) {
                    System.arraycopy(rope.getBytes(), 0, bytes, n, Math.min(rope.byteLength(), size - n));
                }
            }
            CodeRange codeRange = rope.getCodeRange() == CodeRange.CR_7BIT ? CodeRange.CR_7BIT : CodeRange.CR_UNKNOWN;
            Object characterLength = codeRange == CodeRange.CR_7BIT ? Integer.valueOf(size) : NotProvided.INSTANCE;
            return this.allocateObjectNode.allocate(stringClass, this.makeLeafRopeNode.executeMake(bytes, StringOperations.encoding(string), codeRange, characterLength));
        }

        protected boolean patternFitsEvenly(DynamicObject string, int size) {
            assert (RubyGuards.isRubyString(string));
            int byteLength = StringOperations.rope(string).byteLength();
            return byteLength > 0 && size % byteLength == 0;
        }
    }

    @Primitive(name="string_rindex", lowerFixnum={2})
    public static abstract class StringRindexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode patternGetByteNode = RopeNodes.GetByteNode.create();
        @Node.Child
        private RopeNodes.GetByteNode stringGetByteNode = RopeNodes.GetByteNode.create();

        public StringRindexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringRindex(DynamicObject string, DynamicObject pattern, int start, @Cached(value="create()") BranchProfile errorProfile) {
            int pos = start;
            if (pos < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentError("negative start given", this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int matchSize = patternRope.byteLength();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = this.patternGetByteNode.executeGetByte(patternRope, 0);
                    while (pos >= 0) {
                        if (this.stringGetByteNode.executeGetByte(stringRope, pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ByteList.memcmp((byte[])stringRope.getBytes(), (int)cur, (byte[])patternRope.getBytes(), (int)0, (int)matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @Primitive(name="string_copy_from", needsSelf=false, lowerFixnum={3, 4, 5})
    public static abstract class StringCopyFromPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(other)", "size >= 0", "!offsetTooLarge(start, other)", "!offsetTooLargeRaw(dest, string)"})
        public DynamicObject stringCopyFrom(DynamicObject string, DynamicObject other, int start, int size, int dest, @Cached(value="createBinaryProfile()") ConditionProfile negativeStartOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInReplacementProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeDestinationOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInStringProfile) {
            int src = start;
            int dst = dest;
            int cnt = size;
            Rope otherRope = StringOperations.rope(other);
            int osz = otherRope.byteLength();
            if (negativeStartOffsetProfile.profile(src < 0)) {
                src = 0;
            }
            if (sizeTooLargeInReplacementProfile.profile(cnt > osz - src)) {
                cnt = osz - src;
            }
            ByteList stringBytes = RopeOperations.toByteListCopy(Layouts.STRING.getRope(string));
            int sz = stringBytes.unsafeBytes().length - stringBytes.begin();
            if (negativeDestinationOffsetProfile.profile(dst < 0)) {
                dst = 0;
            }
            if (sizeTooLargeInStringProfile.profile(cnt > sz - dst)) {
                cnt = sz - dst;
            }
            System.arraycopy(otherRope.getBytes(), src, stringBytes.getUnsafeBytes(), stringBytes.begin() + dest, cnt);
            StringOperations.setRope(string, StringOperations.ropeFromByteList(stringBytes));
            return string;
        }

        @Specialization(guards={"isRubyString(other)", "size < 0 || (offsetTooLarge(start, other) || offsetTooLargeRaw(dest, string))"})
        public DynamicObject stringCopyFromWithNegativeSize(DynamicObject string, DynamicObject other, int start, int size, int dest) {
            return string;
        }

        protected boolean offsetTooLarge(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return offset >= Layouts.STRING.getRope(string).byteLength();
        }

        protected boolean offsetTooLargeRaw(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            Rope rope = StringOperations.rope(string);
            return offset >= rope.byteLength();
        }
    }

    @Primitive(name="string_previous_byte_index")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringPreviousByteIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"index < 0"})
        @CompilerDirectives.TruffleBoundary
        public Object stringPreviousByteIndexNegativeIndex(DynamicObject string, int index) {
            throw new RaiseException(this.coreExceptions().argumentError("negative index given", this));
        }

        @Specialization(guards={"index == 0"})
        public Object stringPreviousByteIndexZeroIndex(DynamicObject string, int index) {
            return this.nil();
        }

        @Specialization(guards={"index > 0", "isSingleByteOptimizable(string)"})
        public int stringPreviousByteIndexSingleByteOptimizable(DynamicObject string, int index) {
            return index - 1;
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringPreviousByteIndexFixedWidthEncoding(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile firstCharacterProfile) {
            Encoding encoding = StringOperations.encoding(string);
            if (firstCharacterProfile.profile(index < encoding.maxLength())) {
                return 0;
            }
            return (index / encoding.maxLength() - 1) * encoding.maxLength();
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)"})
        @CompilerDirectives.TruffleBoundary
        public Object stringPreviousByteIndex(DynamicObject string, int index) {
            Rope rope = StringOperations.rope(string);
            boolean p = false;
            int end = 0 + rope.byteLength();
            int b = rope.getEncoding().prevCharHead(rope.getBytes(), 0, 0 + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - 0;
        }
    }

    @Primitive(name="string_byte_index", needsSelf=false, lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object stringByteIndexSingleByte(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile) {
            if (indexTooLargeProfile.profile(index > StringOperations.rope(string).byteLength())) {
                return this.nil();
            }
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object stringByteIndex(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile, @Cached(value="createBinaryProfile()") ConditionProfile invalidByteProfile, @Cached(value="create()") BranchProfile errorProfile) {
            int i;
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            int p = 0;
            int e = p + rope.byteLength();
            int k = index;
            if (k < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentError("character index is negative", this));
            }
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength((Encoding)enc, (byte[])rope.getBytes(), (int)p, (int)e);
                if (invalidByteProfile.profile(!StringSupport.MBCLEN_CHARFOUND_P((int)c))) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            }
            if (indexTooLargeProfile.profile(i < k)) {
                return this.nil();
            }
            return p;
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringByteIndex(DynamicObject string, DynamicObject pattern, int offset, @Cached(value="createBinaryProfile()") ConditionProfile emptyPatternProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile, @Cached(value="create()") BranchProfile errorProfile) {
            if (offset < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentError("negative start given", this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            if (emptyPatternProfile.profile(patternRope.isEmpty())) {
                return offset;
            }
            if (brokenCodeRangeProfile.profile(stringRope.getCodeRange() == CodeRange.CR_BROKEN)) {
                return this.nil();
            }
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(this.getContext(), this.getSourceSection(), null, null);
                this.checkEncodingNode = (EncodingNodes.CheckEncodingNode)this.insert(this.checkEncodingNode);
            }
            Encoding encoding = this.checkEncodingNode.executeCheckEncoding(string, pattern);
            int p = 0;
            int e = p + stringRope.byteLength();
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength((Encoding)encoding, (byte[])stringBytes, (int)s, (int)e);
                        if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                            return s;
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @Primitive(name="string_character_index", needsSelf=false, lowerFixnum={3})
    public static abstract class StringCharacterIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringCharacterIndex(DynamicObject string, DynamicObject pattern, int offset) {
            int index;
            int c;
            if (offset < 0) {
                return this.nil();
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int p = 0;
            int e = p + total;
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            if (stringRope.isSingleByteOptimizable()) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = stringRope.getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P((int)(c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e)))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @Primitive(name="string_byte_character_index", needsSelf=false)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexNode
    extends PrimitiveArrayArgumentsNode {
        public abstract int executeStringByteCharacterIndex(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringByteCharacterIndexSingleByte(DynamicObject string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringByteCharacterIndexFixedWidth(DynamicObject string, int index, int start) {
            return index / StringOperations.encoding(string).minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "isValidUtf8(string)"})
        public int stringByteCharacterIndexValidUtf8(DynamicObject string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndex(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            Encoding encoding = rope.getEncoding();
            int p = start;
            int end = bytes.length;
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length((Encoding)encoding, (byte[])bytes, (int)p, (int)end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @Primitive(name="string_character_byte_index", needsSelf=false, lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        public abstract int executeInt(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndex(DynamicObject string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndexMultiByteEncoding(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            return StringSupport.nth((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)start, (int)rope.byteLength(), (int)index);
        }
    }

    @Primitive(name="string_index", lowerFixnum={2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        StringByteCharacterIndexNode byteIndexToCharIndexNode;

        @Specialization(guards={"isRubyString(pattern)", "isBrokenCodeRange(pattern)"})
        public DynamicObject stringIndexBrokenCodeRange(DynamicObject string, DynamicObject pattern, int start) {
            return this.nil();
        }

        @Specialization(guards={"isRubyString(pattern)", "!isBrokenCodeRange(pattern)"})
        public Object stringIndex(VirtualFrame frame, DynamicObject string, DynamicObject pattern, int start) {
            if (this.byteIndexToCharIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.byteIndexToCharIndexNode = (StringByteCharacterIndexNode)this.insert(StringNodesFactory.StringByteCharacterIndexNodeFactory.create(new RubyNode[0]));
            }
            int charIndex = this.byteIndexToCharIndexNode.executeStringByteCharacterIndex(frame, string, start, 0);
            int index = this.index(StringOperations.rope(string), StringOperations.rope(pattern), charIndex, StringOperations.encoding(string));
            if (index == -1) {
                return this.nil();
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        private int index(Rope source, Rope other, int offset, Encoding enc) {
            int sourceLen = source.characterLength();
            int otherLen = other.characterLength();
            if (offset < 0 && (offset += sourceLen) < 0) {
                return -1;
            }
            if (sourceLen - offset < otherLen) {
                return -1;
            }
            byte[] bytes = source.getBytes();
            int p = 0;
            int end = p + source.byteLength();
            if (offset != 0) {
                offset = source.isSingleByteOptimizable() ? offset : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)offset);
                p += offset;
            }
            if (otherLen == 0) {
                return offset;
            }
            int pos;
            while ((pos = this.indexOf(source, other, p)) >= 0) {
                int t = enc.rightAdjustCharHead(bytes, p, p + (pos -= p), end);
                if (t == p + pos) {
                    return pos + offset;
                }
                if ((sourceLen -= t - p) <= 0) {
                    return -1;
                }
                offset += t - p;
                p = t;
            }
            return pos;
        }

        @CompilerDirectives.TruffleBoundary
        private int indexOf(Rope sourceRope, Rope otherRope, int fromIndex) {
            byte[] source = sourceRope.getBytes();
            boolean sourceOffset = false;
            int sourceCount = sourceRope.byteLength();
            byte[] target = otherRope.getBytes();
            boolean targetOffset = false;
            int targetCount = otherRope.byteLength();
            if (fromIndex >= sourceCount) {
                return targetCount == 0 ? sourceCount : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (targetCount == 0) {
                return fromIndex;
            }
            byte first = target[0];
            int max = 0 + (sourceCount - targetCount);
            for (int i = 0 + fromIndex; i <= max; ++i) {
                if (source[i] != first) {
                    while (++i <= max && source[i] != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i - 0;
            }
            return -1;
        }
    }

    @Primitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToF(DynamicObject string, boolean strict) {
            try {
                return Double.parseDouble(string.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @Primitive(name="string_from_codepoint", needsSelf=false, lowerFixnum={1})
    public static abstract class StringFromCodepointPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyEncoding(encoding)", "isSimple(code, encoding)"})
        public DynamicObject stringFromCodepointSimple(int code, DynamicObject encoding, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8Profile, @Cached(value="createBinaryProfile()") ConditionProfile isUSAsciiProfile, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8BitProfile) {
            Encoding realEncoding = EncodingOperations.getEncoding(encoding);
            LeafRope rope = isUTF8Profile.profile(realEncoding == UTF8Encoding.INSTANCE) ? RopeConstants.UTF8_SINGLE_BYTE_ROPES[code] : (isUSAsciiProfile.profile(realEncoding == USASCIIEncoding.INSTANCE) ? RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[code] : (isAscii8BitProfile.profile(realEncoding == ASCIIEncoding.INSTANCE) ? RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[code] : RopeOperations.create(new byte[]{(byte)code}, realEncoding, CodeRange.CR_UNKNOWN)));
            return this.createString(rope);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyEncoding(rubyEncoding)", "!isSimple(code, rubyEncoding)", "isCodepoint(code)"})
        public DynamicObject stringFromCodepoint(long code, DynamicObject rubyEncoding) {
            int length;
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            try {
                length = encoding.codeToMbcLength((int)code);
            }
            catch (EncodingException e) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            if (length <= 0) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            byte[] bytes = new byte[length];
            try {
                encoding.codeToMbc((int)code, bytes, 0);
            }
            catch (EncodingException e) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            if (StringSupport.preciseLength((Encoding)encoding, (byte[])bytes, (int)0, (int)length) != length) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            return this.createString(RopeOperations.create(bytes, encoding, CodeRange.CR_VALID));
        }

        protected boolean isCodepoint(long code) {
            return code >= 0L && code < 0x100000000L;
        }

        protected boolean isSimple(long code, DynamicObject encoding) {
            Encoding enc = EncodingOperations.getEncoding(encoding);
            return enc.isAsciiCompatible() && code >= 0L && code < 128L || enc == ASCIIEncoding.INSTANCE && code >= 0L && code <= 255L;
        }
    }

    @Primitive(name="string_find_character", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringFindCharacterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"offset < 0"})
        public Object stringFindCharacterNegativeOffset(DynamicObject string, int offset) {
            return this.nil();
        }

        @Specialization(guards={"offsetTooLarge(string, offset)"})
        public Object stringFindCharacterOffsetTooLarge(DynamicObject string, int offset) {
            return this.nil();
        }

        @Specialization(guards={"offset >= 0", "!offsetTooLarge(string, offset)", "isSingleByteOptimizable(string)"})
        public Object stringFindCharacterSingleByte(DynamicObject string, int offset) {
            Rope rope = StringOperations.rope(string);
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1));
            return this.propagate(string, ret);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"offset >= 0", "!offsetTooLarge(string, offset)", "!isSingleByteOptimizable(string)"})
        public Object stringFindCharacter(DynamicObject string, int offset) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            int clen = StringSupport.preciseLength((Encoding)enc, (byte[])rope.getBytes(), (int)offset, (int)(offset + enc.maxLength()));
            DynamicObject ret = StringSupport.MBCLEN_CHARFOUND_P((int)clen) ? this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, clen)) : this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1));
            return this.propagate(string, ret);
        }

        private Object propagate(DynamicObject string, DynamicObject ret) {
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(DynamicObject source, DynamicObject value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            return this.taintResultNode.maybeTaint(source, value);
        }

        protected static boolean offsetTooLarge(DynamicObject string, int offset) {
            assert (RubyGuards.isRubyString(string));
            return offset >= StringOperations.rope(string).byteLength();
        }
    }

    @Primitive(name="string_escape", needsSelf=false)
    public static abstract class StringEscapePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject string_escape(DynamicObject string) {
            RubyString rubyString = new RubyString(this.getContext().getJRubyRuntime(), this.getContext().getJRubyRuntime().getString(), StringOperations.getByteListReadOnly(string));
            return this.createString(((RubyString)RubyString.rbStrEscape((ThreadContext)this.getContext().getJRubyRuntime().getCurrentContext(), (RubyString)rubyString)).getByteList());
        }
    }

    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class StringEqualNode
    extends RubyNode {
        @Node.Child
        StringAreComparableNode areComparableNode;

        public abstract boolean executeStringEqual(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"ropeReferenceEqual(string, other)"})
        public boolean stringEqualsRopeEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"!areComparable(string, other)"})
        public boolean stringEqualNotComparable(DynamicObject string, DynamicObject other) {
            return false;
        }

        @Specialization(guards={"areComparable(string, other)", "byteLength(string) != byteLength(other)"})
        public boolean stringEqualDifferentLength(DynamicObject string, DynamicObject other) {
            return false;
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "bytesReferenceEqual(string, other)"})
        public boolean stringEqualsBytesEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "byteLength(string) == 1", "byteLength(other) == 1", "hasRawBytes(string)", "hasRawBytes(other)"})
        public boolean equalCharacters(DynamicObject string, DynamicObject other) {
            Rope a = StringOperations.rope(string);
            Rope b = StringOperations.rope(other);
            return a.getRawBytes()[0] == b.getRawBytes()[0];
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "!bytesReferenceEqual(string, other)", "byteLength(string) == byteLength(other)"}, contains={"equalCharacters"})
        public boolean fullEqual(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile hashCodesCalculatedProfile, @Cached(value="createBinaryProfile()") ConditionProfile differentHashCodesProfile, @Cached(value="createBinaryProfile()") ConditionProfile aHasRawBytesProfile, @Cached(value="createBinaryProfile()") ConditionProfile bHasRawBytesProfile) {
            Rope a = StringOperations.rope(string);
            Rope b = StringOperations.rope(other);
            if (hashCodesCalculatedProfile.profile(a.isHashCodeCalculated() && b.isHashCodeCalculated()) && differentHashCodesProfile.profile(a.hashCode() != b.hashCode())) {
                return false;
            }
            byte[] aBytes = aHasRawBytesProfile.profile(a.getRawBytes() != null) ? a.getRawBytes() : a.getBytes();
            byte[] bBytes = bHasRawBytesProfile.profile(b.getRawBytes() != null) ? b.getRawBytes() : b.getBytes();
            return this.arraysEquals(aBytes, bBytes);
        }

        private boolean arraysEquals(byte[] a, byte[] b) {
            assert (a.length == b.length);
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        protected boolean areComparable(DynamicObject first, DynamicObject second) {
            if (this.areComparableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.areComparableNode = (StringAreComparableNode)this.insert(StringNodesFactory.StringAreComparableNodeGen.create(null, null));
            }
            return this.areComparableNode.executeAreComparable(first, second);
        }

        protected static boolean ropeReferenceEqual(DynamicObject first, DynamicObject second) {
            return StringOperations.rope(first) == StringOperations.rope(second);
        }

        protected static boolean bytesReferenceEqual(DynamicObject first, DynamicObject second) {
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return firstRope.getRawBytes() != null && firstRope.getRawBytes() == secondRope.getRawBytes();
        }

        protected static int byteLength(DynamicObject string) {
            return StringOperations.rope(string).byteLength();
        }

        protected static boolean hasRawBytes(DynamicObject string) {
            return StringOperations.rope(string).getRawBytes() != null;
        }
    }

    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class StringAreComparableNode
    extends RubyNode {
        public abstract boolean executeAreComparable(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"getEncoding(a) == getEncoding(b)"})
        protected boolean sameEncoding(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isEmpty(a)"})
        protected boolean firstEmpty(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isEmpty(b)"})
        protected boolean secondEmpty(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"is7Bit(a)", "is7Bit(b)"})
        protected boolean bothCR7bit(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"is7Bit(a)", "isAsciiCompatible(b)"})
        protected boolean CR7bitASCII(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isAsciiCompatible(a)", "is7Bit(b)"})
        protected boolean ASCIICR7bit(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Fallback
        protected boolean notCompatible(Object a, Object b) {
            return false;
        }

        protected static Encoding getEncoding(DynamicObject string) {
            return StringOperations.rope(string).getEncoding();
        }
    }

    @Primitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(other)"})
        public int stringCompareSubstring(VirtualFrame frame, DynamicObject string, DynamicObject other, int start, int size, @Cached(value="create()") BranchProfile errorProfile) {
            int stringLength = StringOperations.rope(string).characterLength();
            int otherLength = StringOperations.rope(other).characterLength();
            if (start < 0) {
                start += otherLength;
            }
            if (start > otherLength) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().indexError(this.formatError(start), this));
            }
            if (start < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().indexError(this.formatError(start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            Rope rope = StringOperations.rope(string);
            Rope otherRope = StringOperations.rope(other);
            return ByteList.memcmp((byte[])rope.getBytes(), (int)0, (int)size, (byte[])otherRope.getBytes(), (int)start, (int)size);
        }

        @CompilerDirectives.TruffleBoundary
        private String formatError(int start) {
            return StringUtils.format("index %d out of string", start);
        }
    }

    @Primitive(name="string_chr_at", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringChrAtPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"indexOutOfBounds(string, byteIndex)"})
        public Object stringChrAtOutOfBounds(DynamicObject string, int byteIndex) {
            return false;
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "isSingleByteOptimizable(string)"})
        public Object stringChrAtSingleByte(DynamicObject string, int byteIndex, @Cached(value="create(getContext(), getSourceSection())") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, 1);
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "!isSingleByteOptimizable(string)"})
        public Object stringChrAt(DynamicObject string, int byteIndex, @Cached(value="create(getContext(), getSourceSection())") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            int end;
            Rope rope = StringOperations.rope(string);
            int c = this.preciseLength(rope, byteIndex, end = rope.byteLength());
            if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, n);
        }

        @CompilerDirectives.TruffleBoundary
        private int preciseLength(Rope rope, int p, int end) {
            return StringSupport.preciseLength((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)p, (int)end);
        }

        protected static boolean indexOutOfBounds(DynamicObject string, int byteIndex) {
            return byteIndex < 0 || byteIndex >= StringOperations.rope(string).byteLength();
        }
    }

    @Primitive(name="string_byte_substring")
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="length")})
    public static abstract class StringByteSubstringPrimitiveNode
    extends PrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public static StringByteSubstringPrimitiveNode create(RubyContext context, SourceSection sourceSection) {
            return StringNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(context, sourceSection, null, null, null);
        }

        public StringByteSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ArrayAttributeCastNodeGen.create(null, null, "index", index);
        }

        @CreateCast(value={"length"})
        public RubyNode coerceLengthToInt(RubyNode length) {
            return ArrayAttributeCastNodeGen.create(null, null, "length", length);
        }

        public Object executeStringByteSubstring(DynamicObject string, Object index, Object length) {
            return this.nil();
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile, @Cached(value="createBinaryProfile()") ConditionProfile nilSubstringProfile, @Cached(value="createBinaryProfile()") ConditionProfile emptySubstringProfile) {
            DynamicObject subString = (DynamicObject)this.stringByteSubstring(string, index, 1, negativeLengthProfile, indexOutOfBoundsProfile, lengthTooLongProfile);
            if (nilSubstringProfile.profile(subString == this.nil())) {
                return subString;
            }
            if (emptySubstringProfile.profile(StringOperations.rope(subString).isEmpty())) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile) {
            if (negativeLengthProfile.profile(length < 0)) {
                return this.nil();
            }
            Rope rope = StringOperations.rope(string);
            int stringByteLength = rope.byteLength();
            int normalizedIndex = StringOperations.normalizeIndex(stringByteLength, index);
            if (indexOutOfBoundsProfile.profile(normalizedIndex < 0 || normalizedIndex > stringByteLength)) {
                return this.nil();
            }
            if (lengthTooLongProfile.profile(normalizedIndex + length > stringByteLength)) {
                length = rope.byteLength() - normalizedIndex;
            }
            Rope substringRope = this.makeSubstringNode.executeMake(rope, normalizedIndex, length);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope);
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization(guards={"isRubyRange(range)"})
        public Object stringByteSubstring(DynamicObject string, DynamicObject range, NotProvided length) {
            return null;
        }
    }

    @Primitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringAwkSplitPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject stringAwkSplit(DynamicObject string, int lim) {
            int p;
            ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
            Rope rope = StringOperations.rope(string);
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = rope.getBytes();
            int ptr = p = 0;
            int len = rope.byteLength();
            int end = p + len;
            Encoding enc = rope.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = rope.isSingleByteOptimizable();
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    try {
                        c = RopeOperations.codePoint(this.getContext(), rope, p);
                    }
                    catch (org.jruby.exceptions.RaiseException ex) {
                        throw new RaiseException(this.getContext().getJRubyInterop().toTruffle(ex.getException(), this));
                    }
                    p += StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            Object[] objects = ret.toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject makeString(DynamicObject source, int index, int length) {
            assert (RubyGuards.isRubyString(source));
            Rope rope = this.makeSubstringNode.executeMake(StringOperations.rope(source), index, length);
            DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), rope);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @Primitive(name="string_append")
    public static abstract class StringAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode;

        public StringAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(context, sourceSection, null, null);
            this.makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        }

        public abstract DynamicObject executeStringAppend(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringAppend(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            Encoding compatibleEncoding = this.checkEncodingNode.executeCheckEncoding(string, other);
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, right, compatibleEncoding));
            return string;
        }
    }

    @Primitive(name="character_printable_p")
    public static abstract class CharacterPrintablePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isCharacterPrintable(DynamicObject character) {
            Rope rope = StringOperations.rope(character);
            Encoding encoding = rope.getEncoding();
            int codepoint = encoding.mbcToCode(rope.getBytes(), 0, rope.byteLength());
            return encoding.isPrint(codepoint);
        }
    }

    @Primitive(name="character_ascii_p")
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterAsciiPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"is7Bit(character)"})
        public boolean isCharacterAscii(DynamicObject character) {
            return !StringOperations.rope(character).isEmpty();
        }

        @Specialization(guards={"!is7Bit(character)"})
        public boolean isCharacterAsciiMultiByte(DynamicObject character) {
            Rope rope = StringOperations.rope(character);
            int codepoint = StringSupport.preciseCodePoint((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)0, (int)rope.byteLength());
            boolean found = codepoint != -1;
            return found && Encoding.isAscii((int)codepoint);
        }
    }

    public static class StringNodesHelper {
        public static int checkIndex(int length, int index, RubyNode node) {
            if (index > length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(node.getContext().getCoreExceptions().indexError(StringUtils.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new RaiseException(node.getContext().getCoreExceptions().indexError(StringUtils.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        public static int checkIndexForRef(DynamicObject string, int index, RubyNode node) {
            assert (RubyGuards.isRubyString(string));
            int length = StringOperations.rope(string).byteLength();
            if (index >= length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(node.getContext().getCoreExceptions().indexError(StringUtils.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new RaiseException(node.getContext().getCoreExceptions().indexError(StringUtils.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, EncodingNodes.CheckEncodingNode checkEncodingNode, DynamicObject self, DynamicObject fromStr, DynamicObject toStr, boolean sFlag) {
            assert (RubyGuards.isRubyString(self));
            assert (RubyGuards.isRubyString(fromStr));
            assert (RubyGuards.isRubyString(toStr));
            StringCodeRangeableWrapper buffer = StringOperations.getCodeRangeableReadWrite(self, checkEncodingNode);
            CodeRangeable ret = StringSupport.trTransHelper((Ruby)context.getJRubyRuntime(), (CodeRangeable)buffer, (CodeRangeable)StringOperations.getCodeRangeableReadOnly(fromStr, checkEncodingNode), (CodeRangeable)StringOperations.getCodeRangeableReadOnly(toStr, checkEncodingNode), (boolean)sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            StringOperations.setRope(self, StringOperations.ropeFromByteList(buffer.getByteList(), buffer.getCodeRange()));
            return self;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodes.MakeSubstringNode.createX();

        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject clear(DynamicObject string) {
            StringOperations.setRope(string, this.makeSubstringNode.executeMake(StringOperations.rope(string), 0, 0));
            return string;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public DynamicObject capitalizeBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(StringUtils.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            StringOperations.keepCodeRange(string);
            int s = 0;
            int end = s + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            boolean modify = false;
            int c = RopeOperations.codePoint(this.getContext(), rope, s);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper((Encoding)enc, (int)c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength((Encoding)enc, (int)c);
            while (s < end) {
                c = RopeOperations.codePoint(this.getContext(), rope, s);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower((Encoding)enc, (int)c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength((Encoding)enc, (int)c);
            }
            if (modify) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isBrokenCodeRange(string)"})
        public boolean validEncodingQueryBroken(DynamicObject string) {
            return false;
        }

        @Specialization(guards={"!isBrokenCodeRange(string)"})
        public boolean validEncodingQuery(DynamicObject string) {
            return true;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class UpcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public DynamicObject upcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile isEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            if (isEmptyProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] bytes = rope.getBytesCopy();
            boolean modified = this.singleByteUpcase(bytes, 0, bytes.length);
            if (modifiedProfile.profile(modified)) {
                LeafRope newRope = this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength());
                StringOperations.setRope(string, newRope);
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject upcase(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(StringUtils.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            ByteList bytes = RopeOperations.toByteListCopy(rope);
            try {
                boolean modified = this.multiByteUpcase(encoding, bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
                if (modified) {
                    StringOperations.setRope(string, StringOperations.ropeFromByteList(bytes, rope.getCodeRange()));
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteUpcase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteUpcase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteUpcase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteUpcase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"unpack"}, required=1, taintFrom=1)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private TaintNode taintNode;
        private final BranchProfile exceptionProfile = BranchProfile.create();

        @Specialization(guards={"isRubyString(format)", "ropesEqual(format, cachedFormat)"}, limit="getCacheLimit()")
        public DynamicObject unpackCached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="privatizeRope(format)") Rope cachedFormat, @Cached(value="create(compileFormat(format))") DirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        @Specialization(contains={"unpackCached"}, guards={"isRubyString(format)"})
        public DynamicObject unpackUncached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="create()") IndirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, this.compileFormat(format), new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        private DynamicObject finishUnpack(ArrayResult result) {
            DynamicObject array = Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), result.getOutput(), result.getOutputLength());
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(array);
            }
            return array;
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object unpack(VirtualFrame frame, DynamicObject array, Object format, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "unpack(format.to_str)", "format", format);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            return new UnpackCompiler(this.getContext(), this).compile(format.toString());
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().UNPACK_CACHE;
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrSBangNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(null, null, fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(null, null, toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public DynamicObject trSBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trSBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.executeDeleteBang(frame, self, new DynamicObject[]{fromStr});
            }
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = (EncodingNodes.CheckEncodingNode)this.insert(EncodingNodesFactory.CheckEncodingNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return StringNodesHelper.trTransHelper(this.getContext(), this.checkEncodingNode, self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrBangNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(null, null, fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(null, null, toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public Object trBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.executeDeleteBang(frame, self, new DynamicObject[]{fromStr});
            }
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = (EncodingNodes.CheckEncodingNode)this.insert(EncodingNodesFactory.CheckEncodingNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return StringNodesHelper.trTransHelper(this.getContext(), this.checkEncodingNode, self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"reverseIsEqualToSelf(string)"})
        public DynamicObject reverseNoOp(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject reverseSingleByteOptimizable(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int len = originalBytes.length;
            byte[] reversedBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                reversedBytes[len - i - 1] = originalBytes[i];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "!isSingleByteOptimizable(string)"})
        public DynamicObject reverse(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int p = 0;
            int len = originalBytes.length;
            Encoding enc = rope.getEncoding();
            int end = p + len;
            int op = len;
            byte[] reversedBytes = new byte[len];
            while (p < end) {
                int cl = StringSupport.length((Encoding)enc, (byte[])originalBytes, (int)p, (int)end);
                if (cl > 1 || (originalBytes[p] & 0x80) != 0) {
                    System.arraycopy(originalBytes, p, reversedBytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                reversedBytes[--op] = originalBytes[p++];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        public static boolean reverseIsEqualToSelf(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string).characterLength() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toSym(DynamicObject string) {
            return this.getSymbol(StringOperations.rope(string));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isStringSubclass(string)"})
        public DynamicObject toS(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        public Object toSOnSubclass(VirtualFrame frame, DynamicObject string, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(DynamicObject string) {
            return Layouts.BASIC_OBJECT.getLogicalClass(string) != this.coreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(DynamicObject string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(DynamicObject string) {
            return ConvertDouble.byteListToDouble19((ByteList)StringOperations.getByteListReadOnly(string), (boolean)false);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode addNode;
        @Node.Child
        private CallDispatchHeadNode subNode;
        @Node.Child
        private CallDispatchHeadNode shiftNode;
        @Node.Child
        private CallDispatchHeadNode andNode;

        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.subNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.shiftNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.andNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, long bits) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int p = 0;
            int len = rope.byteLength();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", bits);
                    sum = this.andNode.call(frame, sum, "&", this.subNode.call(frame, mod, "-", 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, NotProvided bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(bits)", "!isLong(bits)", "wasProvided(bits)"})
        public Object sum(VirtualFrame frame, DynamicObject string, Object bits, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject succBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            if (!rope.isEmpty()) {
                ByteList succByteList = StringSupport.succCommon((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string));
                StringOperations.setRope(string, StringOperations.ropeFromByteList(succByteList, rope.getCodeRange()));
            }
            return string;
        }
    }

    @CoreMethod(names={"squeeze!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject squeezeBangEmptyString(DynamicObject string, Object[] args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "zeroArgs(args)"})
        @CompilerDirectives.TruffleBoundary
        public Object squeezeBangZeroArgs(DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (!StringSupport.singleByteSqueeze((ByteList)buffer, (boolean[])squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            } else {
                if (!this.squeezeCommonMultiByte(buffer, squeeze, null, StringOperations.encoding(string), false)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @Specialization(guards={"!isEmpty(string)", "!zeroArgs(args)"})
        public Object squeezeBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeToStr(frame, args[i]);
            }
            return this.performSqueezeBang(string, otherStrings, singleByteOptimizableProfile);
        }

        @CompilerDirectives.TruffleBoundary
        private Object performSqueezeBang(DynamicObject string, DynamicObject[] otherStrings, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(this.getContext(), this.getSourceSection(), null, null);
                this.checkEncodingNode = (EncodingNodes.CheckEncodingNode)this.insert(this.checkEncodingNode);
            }
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            DynamicObject otherStr = otherStrings[0];
            Rope otherRope = StringOperations.rope(otherStr);
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)RopeOperations.getByteListReadOnly(otherRope), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            boolean singlebyte = rope.isSingleByteOptimizable() && otherRope.isSingleByteOptimizable();
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                otherRope = StringOperations.rope(otherStr);
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
                singlebyte = singlebyte && otherRope.isSingleByteOptimizable();
                tables = StringSupport.trSetupTable((ByteList)RopeOperations.getByteListReadOnly(otherRope), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            if (singleByteOptimizableProfile.profile(singlebyte)) {
                if (!StringSupport.singleByteSqueeze((ByteList)buffer, (boolean[])squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            } else {
                if (!StringSupport.multiByteSqueeze((Ruby)this.getContext().getJRubyRuntime(), (ByteList)buffer, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)true)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze((Ruby)this.getContext().getJRubyRuntime(), (ByteList)value, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)isArg);
        }

        public static boolean zeroArgs(Object[] args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile, @Cached(value="createBinaryProfile()") ConditionProfile isSingleByteOptimizableRopeBufferProfile) {
            Rope rope = StringOperations.rope(string);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                if (isSingleByteOptimizableRopeBufferProfile.profile(rope.isSingleByteOptimizable())) {
                    return ((RopeBuffer)rope).getByteList().realSize();
                }
                ByteList byteList = ((RopeBuffer)rope).getByteList();
                return RopeOperations.strLength(rope.getEncoding(), byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
            }
            return rope.characterLength();
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class SetByteNode
    extends CoreMethodNode {
        @Node.Child
        private RopeNodes.MakeConcatNode composedMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode middleMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(null, null, ToIntNodeGen.create(index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return FixnumLowerNodeGen.create(null, null, ToIntNodeGen.create(value));
        }

        public abstract int executeSetByte(DynamicObject var1, int var2, Object var3);

        @Specialization(guards={"!isRopeBuffer(string)"})
        public int setByte(DynamicObject string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            Rope rope = StringOperations.rope(string);
            Rope left = this.leftMakeSubstringNode.executeMake(rope, 0, normalizedIndex);
            Rope right = this.rightMakeSubstringNode.executeMake(rope, normalizedIndex + 1, rope.byteLength() - normalizedIndex - 1);
            LeafRope middle = this.makeLeafRopeNode.executeMake(new byte[]{(byte)value}, rope.getEncoding(), CodeRange.CR_UNKNOWN, NotProvided.INSTANCE);
            Rope composed = this.composedMakeConcatNode.executeMake(this.middleMakeConcatNode.executeMake(left, middle, rope.getEncoding()), right, rope.getEncoding());
            StringOperations.setRope(string, composed);
            return value;
        }

        @Specialization(guards={"isRopeBuffer(string)"})
        public int setByteRopeBuffer(DynamicObject string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            RopeBuffer rope = (RopeBuffer)StringOperations.rope(string);
            rope.getByteList().set(normalizedIndex, value);
            return value;
        }

        protected boolean isRopeBuffer(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string) instanceof RopeBuffer;
        }
    }

    @CoreMethod(names={"dump"}, taintFrom=0)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isAsciiCompatible(string)"})
        public DynamicObject dumpAsciiCompatible(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            outputBytes.setEncoding(StringOperations.encoding(string));
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), StringOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT));
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isAsciiCompatible(string)"})
        public DynamicObject dump(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(StringOperations.encoding(string).getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            outputBytes.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), StringOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT));
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringSupport.dumpCommon((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string));
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public SwapcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject swapcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(StringUtils.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (StringSupport.singleByteSwapcase((byte[])bytes, (int)0, (int)end)) {
                    StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                    return string;
                }
            } else if (StringSupport.multiByteSwapcase((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)0, (int)end)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public RstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject rstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object rstripBangSingleByte(DynamicObject string) {
            int endp;
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int end = rope.byteLength();
            for (endp = end - 1; endp >= 0 && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0 + 1));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object rstripBang(DynamicObject string) {
            int point;
            int prev;
            int end;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int endp = end = rope.byteLength();
            while ((prev = this.prevCharHead(enc, bytes, 0, endp, end)) != -1 && ((point = RopeOperations.codePoint(this.getContext(), rope, prev)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFrom=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"string == other"})
        public DynamicObject replaceStringIsSameAsOther(DynamicObject string, DynamicObject other) {
            return string;
        }

        @Specialization(guards={"string != other", "isRubyString(other)"})
        public DynamicObject replace(DynamicObject string, DynamicObject other) {
            StringOperations.setRope(string, StringOperations.rope(other));
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode ropeGetByteNode;

        @Specialization(guards={"isEmpty(string)"})
        @CompilerDirectives.TruffleBoundary
        public int ordEmpty(DynamicObject string) {
            throw new RaiseException(this.coreExceptions().argumentError("empty string", this));
        }

        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public int ordAsciiOnly(DynamicObject string) {
            if (this.ropeGetByteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ropeGetByteNode = (RopeNodes.GetByteNode)this.insert(RopeNodes.GetByteNode.create());
            }
            return this.ropeGetByteNode.executeGetByte(StringOperations.rope(string), 0);
        }

        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public int ord(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            try {
                return RopeOperations.codePoint(this.getContext(), rope, 0);
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public LstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject lstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object lstripBangSingleByte(DynamicObject string) {
            int p;
            Rope rope = StringOperations.rope(string);
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytes();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object lstripBang(DynamicObject string) {
            int p;
            int c;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            boolean s = false;
            int end = 0 + rope.byteLength();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(c = RopeOperations.codePoint(this.getContext(), rope, p)); p += StringSupport.codeLength((Encoding)enc, (int)c)) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnum={1}, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="otherString")})
    public static abstract class InsertNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode appendNode;
        @Node.Child
        private CharacterByteIndexNode characterByteIndexNode = StringNodesFactory.CharacterByteIndexNodeFactory.create(new RubyNode[0]);
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private RopeNodes.MakeConcatNode prependMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode leftMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode rightMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(context, sourceSection, null, null);
            this.leftMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
            this.rightMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
            this.leftMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
            this.rightMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeGen.create(index);
        }

        @CreateCast(value={"otherString"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"indexAtStartBound(index)", "isRubyString(other)"})
        public Object insertPrepend(DynamicObject string, int index, DynamicObject other) {
            Rope left = StringOperations.rope(other);
            Rope right = StringOperations.rope(string);
            Encoding compatibleEncoding = this.checkEncodingNode.executeCheckEncoding(string, other);
            if (this.prependMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.prependMakeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.prependMakeConcatNode.executeMake(left, right, compatibleEncoding));
            return this.taintResultNode.maybeTaint(other, string);
        }

        @Specialization(guards={"indexAtEndBound(index)", "isRubyString(other)"})
        public Object insertAppend(VirtualFrame frame, DynamicObject string, int index, DynamicObject other) {
            if (this.appendNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            this.appendNode.call(frame, string, "append", other);
            return this.taintResultNode.maybeTaint(other, string);
        }

        @Specialization(guards={"!indexAtEitherBounds(index)", "isRubyString(other)"})
        public Object insert(VirtualFrame frame, DynamicObject string, int index, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            if (negativeIndexProfile.profile(index < 0)) {
                ++index;
            }
            Rope source = StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            Encoding compatibleEncoding = this.checkEncodingNode.executeCheckEncoding(string, other);
            int stringLength = source.characterLength();
            int normalizedIndex = StringNodesHelper.checkIndex(stringLength, index, this);
            int byteIndex = this.characterByteIndexNode.executeInt(frame, string, normalizedIndex, 0);
            Rope splitLeft = this.leftMakeSubstringNode.executeMake(source, 0, byteIndex);
            Rope splitRight = this.rightMakeSubstringNode.executeMake(source, byteIndex, source.byteLength() - byteIndex);
            Rope joinedLeft = this.leftMakeConcatNode.executeMake(splitLeft, insert, compatibleEncoding);
            Rope joinedRight = this.rightMakeConcatNode.executeMake(joinedLeft, splitRight, compatibleEncoding);
            StringOperations.setRope(string, joinedRight);
            return this.taintResultNode.maybeTaint(other, string);
        }

        protected boolean indexAtStartBound(int index) {
            return index == 0;
        }

        protected boolean indexAtEndBound(int index) {
            return index == -1;
        }

        protected boolean indexAtEitherBounds(int index) {
            return this.indexAtStartBound(index) || this.indexAtEndBound(index);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"self == from"})
        public Object initializeCopySelfIsSameAsFrom(DynamicObject self, DynamicObject from) {
            return self;
        }

        @Specialization(guards={"self != from", "isRubyString(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            StringOperations.setRope(self, StringOperations.rope(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, taintFrom=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization
        public DynamicObject initialize(DynamicObject self, NotProvided from) {
            return self;
        }

        @Specialization
        public DynamicObject initializeJavaString(DynamicObject self, String from) {
            this.raiseIfFrozen(self);
            StringOperations.setRope(self, StringOperations.createRope(from, (Encoding)ASCIIEncoding.INSTANCE));
            return self;
        }

        @Specialization(guards={"isRubyString(from)"})
        public DynamicObject initialize(DynamicObject self, DynamicObject from) {
            this.raiseIfFrozen(self);
            StringOperations.setRope(self, StringOperations.rope(from));
            return self;
        }

        @Specialization(guards={"!isRubyString(from)", "!isString(from)", "wasProvided(from)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.initialize(self, this.toStrNode.executeToStr(frame, from));
        }

        protected void raiseIfFrozen(Object object) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            this.isFrozenNode.raiseIfFrozen(object);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject string) {
            return StringOperations.rope(string).hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1, lowerFixnum={1})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode ropeGetByteNode = RopeNodesFactory.GetByteNodeGen.create(null, null);

        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            Rope rope = StringOperations.rope(string);
            if (negativeIndexProfile.profile(index < 0)) {
                index += rope.byteLength();
            }
            if (indexOutOfBoundsProfile.profile(index < 0 || index >= rope.byteLength())) {
                return this.nil();
            }
            return this.ropeGetByteNode.executeGetByte(rope, index);
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);
        @Node.Child
        private ToStrNode toStrNode;

        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(encodingName)"})
        public DynamicObject forceEncodingString(DynamicObject string, DynamicObject encodingName, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            DynamicObject encoding = this.getContext().getEncodingManager().getRubyEncoding(encodingName.toString());
            return this.forceEncodingEncoding(string, encoding, differentEncodingProfile, mutableRopeProfile);
        }

        @Specialization(guards={"isRubyEncoding(rubyEncoding)"})
        public DynamicObject forceEncodingEncoding(DynamicObject string, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope rope = StringOperations.rope(string);
            if (differentEncodingProfile.profile(rope.getEncoding() != encoding)) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    ((RopeBuffer)rope).getByteList().setEncoding(encoding);
                } else {
                    Rope newRope = this.withEncodingNode.executeWithEncoding(rope, encoding, CodeRange.CR_UNKNOWN);
                    StringOperations.setRope(string, newRope);
                }
            }
            return string;
        }

        @Specialization(guards={"!isRubyString(encoding)", "!isRubyEncoding(encoding)"})
        public DynamicObject forceEncoding(VirtualFrame frame, DynamicObject string, Object encoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.forceEncodingString(string, this.toStrNode.executeToStr(frame, encoding), differentEncodingProfile, mutableRopeProfile);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject encoding(DynamicObject string) {
            return this.getContext().getEncodingManager().getRubyEncoding(StringOperations.encoding(string));
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class IsEmptyNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean executeIsEmpty(DynamicObject var1);

        @Specialization
        public boolean empty(DynamicObject string) {
            return StringOperations.rope(string).isEmpty();
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object inspect(DynamicObject string) {
            DynamicObject result = this.createString(RubyString.inspect((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string)).getByteList());
            return this.taintResultNode.maybeTaint(string, result);
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public EachCharNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isValidOr7BitEncoding(string)"})
        public DynamicObject eachChar(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen((byte[])ptrBytes, (int)i, (int)len, (Encoding)enc);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @Specialization(guards={"!isValidOr7BitEncoding(string)"})
        public DynamicObject eachCharMultiByteEncoding(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, i, len);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        }

        private Object substr(Rope rope, DynamicObject string, int beg, int len) {
            int length = rope.byteLength();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            Rope substringRope = this.makeSubstringNode.executeMake(rope, beg, end - beg);
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, enumeratorSize="bytesize")
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject eachByte(VirtualFrame frame, DynamicObject string, DynamicObject block, @Cached(value="createBinaryProfile()") ConditionProfile ropeChangedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
                Rope updatedRope = StringOperations.rope(string);
                if (!ropeChangedProfile.profile(rope != updatedRope)) continue;
                rope = updatedRope;
                bytes = updatedRope.getBytes();
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DowncaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByteEmpty(DynamicObject string) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] outputBytes = rope.getBytesCopy();
            boolean modified = this.singleByteDowncase(outputBytes, 0, outputBytes.length);
            if (modifiedProfile.profile(modified)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject downcase(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(StringUtils.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] outputBytes = rope.getBytesCopy();
            try {
                boolean modified = this.multiByteDowncase(encoding, outputBytes, 0, outputBytes.length);
                if (modifiedProfile.profile(modified)) {
                    StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteDowncase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteDowncase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteDowncase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteDowncase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"delete!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private ToStrNode toStr;

        public DeleteBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(context, sourceSection, null, null);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        public abstract DynamicObject executeDeleteBang(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject deleteBangEmpty(DynamicObject string, Object[] args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)"})
        public Object deleteBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="create()") BranchProfile errorProfile) {
            if (args.length == 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.deleteBangSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(DynamicObject string, DynamicObject[] otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherString = otherStrings[0];
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherString);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherString), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                assert (RubyGuards.isRubyString(otherStrings[i]));
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStrings[i]);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStrings[i]), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            StringCodeRangeableWrapper buffer = StringOperations.getCodeRangeableReadWrite(string, this.checkEncodingNode);
            if (StringSupport.delete_bangCommon19((CodeRangeable)buffer, (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc) == null) {
                return this.nil();
            }
            StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer.getByteList(), buffer.getCodeRange()));
            return string;
        }
    }

    @CoreMethod(names={"crypt"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="salt")})
    public static abstract class CryptNode
    extends CoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(salt)"})
        public Object crypt(DynamicObject string, DynamicObject salt) {
            Rope value = StringOperations.rope(string);
            Rope other = StringOperations.rope(salt);
            if (other.byteLength() < 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", this));
            }
            TrufflePosix posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.getBytes(), 0, value.byteLength());
            byte[] saltBytes = Arrays.copyOfRange(other.getBytes(), 0, other.byteLength());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.coreExceptions().errnoError(posix.errno(), this));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.createString(StringOperations.ropeFromByteList(new ByteList(cryptedString, 0, cryptedString.length - 1, (Encoding)ASCIIEncoding.INSTANCE, false)));
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(salt, ret);
            return ret;
        }
    }

    @CoreMethod(names={"count"}, rest=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private ToStrNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(context, sourceSection, null, null);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization(guards={"isEmpty(string)"})
        public int count(DynamicObject string, Object[] args) {
            return 0;
        }

        @Specialization(guards={"!isEmpty(string)"})
        public int count(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="create()") BranchProfile errorProfile) {
            if (args.length == 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.countSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherStr = otherStrings[0];
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStr), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                assert (RubyGuards.isRubyString(otherStr));
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStr), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            return StringSupport.strCount((ByteList)StringOperations.getByteListReadOnly(string), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (Encoding)enc);
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class CaseCmpNode
    extends CoreMethodNode {
        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isRubyString(other)", "bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmpSingleByte(DynamicObject string, DynamicObject other) {
            if (RopeOperations.areCompatible(StringOperations.rope(string), StringOperations.rope(other)) == null) {
                return this.nil();
            }
            return StringOperations.getByteListReadOnly(string).caseInsensitiveCmp(StringOperations.getByteListReadOnly(other));
        }

        @Specialization(guards={"isRubyString(other)", "!bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmp(DynamicObject string, DynamicObject other) {
            Encoding encoding = RopeOperations.areCompatible(StringOperations.rope(string), StringOperations.rope(other));
            if (encoding == null) {
                return this.nil();
            }
            return this.multiByteCasecmp(encoding, StringOperations.getByteListReadOnly(string), StringOperations.getByteListReadOnly(other));
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteCasecmp(Encoding enc, ByteList value, ByteList otherValue) {
            return StringSupport.multiByteCasecmp((Encoding)enc, (ByteList)value, (ByteList)otherValue);
        }

        public static boolean bothSingleByteOptimizable(DynamicObject string, DynamicObject other) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(other));
            return StringOperations.rope(string).isSingleByteOptimizable() && StringOperations.rope(other).isSingleByteOptimizable();
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int byteSize(DynamicObject string) {
            return StringOperations.rope(string).byteLength();
        }
    }

    @CoreMethod(names={"bytes"}, needsBlock=true)
    public static abstract class BytesNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, NotProvided block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int[] store = new int[bytes.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n] & 0xFF;
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"b"}, taintFrom=0)
    public static abstract class BNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);

        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject b(DynamicObject string) {
            Rope newRope = this.withEncodingNode.executeWithEncoding(StringOperations.rope(string), (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_UNKNOWN);
            return this.createString(newRope);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isAsciiCompatible(string)", "is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible7BitCR(DynamicObject string) {
            return true;
        }

        @Specialization(guards={"isAsciiCompatible(string)", "!is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible(DynamicObject string) {
            return false;
        }

        @Specialization(guards={"!isAsciiCompatible(string)"})
        public boolean asciiOnly(DynamicObject string) {
            return false;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnum={1, 2}, taintFrom=0)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private StringSubstringPrimitiveNode substringNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNode.create();
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, int index, Object length) {
            if (index == StringOperations.rope(string).characterLength()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "!isRubyString(index)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, Object index, Object length) {
            return this.getIndex(frame, string, this.getToIntNode().doInt(frame, index), length);
        }

        @Specialization(guards={"isIntRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceIntegerRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, Layouts.INT_RANGE.getBegin(range), Layouts.INT_RANGE.getEnd(range), Layouts.INT_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isLongRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceLongRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, (int)Layouts.LONG_RANGE.getBegin(range), (int)Layouts.LONG_RANGE.getEnd(range), Layouts.LONG_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isObjectRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceObjectRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            int coercedBegin = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getBegin(range));
            int coercedEnd = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getEnd(range));
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, Layouts.OBJECT_RANGE.getExcludedEnd(range));
        }

        private Object sliceRange(VirtualFrame frame, DynamicObject string, int begin, int end, boolean doesExcludeEnd) {
            assert (RubyGuards.isRubyString(string));
            int stringLength = StringOperations.rope(string).characterLength();
            begin = StringOperations.normalizeIndex(stringLength, begin);
            if (begin < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                ByteList byteList = new ByteList();
                byteList.setEncoding(StringOperations.encoding(string));
                return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), RopeOperations.withEncodingVerySlow(RopeConstants.EMPTY_ASCII_8BIT_ROPE, StringOperations.encoding(string)));
            }
            end = StringOperations.normalizeIndex(stringLength, end);
            int length = StringOperations.clampExclusiveIndex(string, doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, DynamicObject string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, int start, Object length) {
            return this.slice(frame, string, start, this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "!isRubyString(start)", "wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, Object start, Object length) {
            return this.slice(frame, string, this.getToIntNode().doInt(frame, start), this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasNotProvided(capture) || isRubiniusUndefined(capture)"})
        public Object slice1(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "match, str = subpattern(index, 0); Regexp.last_match = match; str", "index", regexp);
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasProvided(capture)"})
        public Object sliceCapture(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "match, str = subpattern(index, other); Regexp.last_match = match; str", "index", regexp, "other", capture);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)", "isRubyString(matchStr)"})
        public Object slice2(VirtualFrame frame, DynamicObject string, DynamicObject matchStr, Object length) {
            boolean result;
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.includeNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.dupNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", new Object[0]));
            }
            return this.nil();
        }

        private ToIntNode getToIntNode() {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (ToIntNode)this.insert(ToIntNode.create());
            }
            return this.toIntNode;
        }

        private StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = (StringSubstringPrimitiveNode)this.insert(StringNodesFactory.StringSubstringPrimitiveNodeFactory.create(null));
            }
            return this.substringNode;
        }

        @Override
        protected boolean isRubiniusUndefined(Object object) {
            return object == this.coreLibrary().getRubiniusUndefined();
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFrom=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode;
        @Node.Child
        private StringAppendPrimitiveNode stringAppendNode;

        @Specialization(guards={"isRubyString(other)", "is7Bit(string)", "is7Bit(other)"})
        public DynamicObject concatStringSingleByte(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            if (this.makeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.makeConcatNode = (RopeNodes.MakeConcatNode)this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, right, left.getEncoding()));
            return string;
        }

        @Specialization(guards={"isRubyString(other)", "!is7Bit(string) || !is7Bit(other)"})
        public Object concatString(DynamicObject string, DynamicObject other) {
            if (this.stringAppendNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringAppendNode = (StringAppendPrimitiveNode)this.insert(StringNodesFactory.StringAppendPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.stringAppendNode.executeStringAppend(string, other);
        }

        @Specialization(guards={"!isRubyString(other)"})
        public Object concat(VirtualFrame frame, DynamicObject string, Object other, @Cached(value="createMethodCall()") CallDispatchHeadNode callNode) {
            return callNode.call(frame, string, "concat_internal", other);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isRubyString(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            Rope secondRope;
            Rope firstRope = StringOperations.rope(a);
            int ret = RopeOperations.cmp(firstRope, secondRope = StringOperations.rope(b));
            if (ret == 0 && !RopeOperations.areComparable(firstRope, secondRope)) {
                return firstRope.getEncoding().getIndex() > secondRope.getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(b)"})
        public Object compare(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, b, this.create7BitString("to_str", (Encoding)UTF8Encoding.INSTANCE), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                try {
                    DynamicObject coerced = this.toStrNode.executeToStr(frame, b);
                    return this.compare(a, coerced);
                }
                catch (RaiseException e) {
                    if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToCmpNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToCmpNode.doesRespondToString(frame, b, this.create7BitString("<=>", (Encoding)UTF8Encoding.INSTANCE), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cmpNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cmpIntNode = (CmpIntNode)this.insert(CmpIntNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringEqualNode stringEqualNode = StringNodesFactory.StringEqualNodeGen.create(null, null);
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;
        @Node.Child
        private CheckLayoutNode checkLayoutNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return this.stringEqualNode.executeStringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToNode.doesRespondToString(frame, b, this.create7BitString("to_str", (Encoding)UTF8Encoding.INSTANCE), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.objectEqualNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }

        protected boolean isRubyString(DynamicObject object) {
            if (this.checkLayoutNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkLayoutNode = (CheckLayoutNode)this.insert(new CheckLayoutNode());
            }
            return this.checkLayoutNode.isString(object);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnum={1}, taintFrom=0)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract DynamicObject executeInt(VirtualFrame var1, DynamicObject var2, int var3);

        @Specialization(guards={"times < 0"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject multiplyTimesNegative(DynamicObject string, int times) {
            throw new RaiseException(this.coreExceptions().argumentError("negative argument", this));
        }

        @Specialization(guards={"times >= 0"})
        public DynamicObject multiply(DynamicObject string, int times, @Cached(value="create()") RopeNodes.MakeRepeatingNode makeRepeatingNode) {
            Rope repeated = makeRepeatingNode.executeMake(StringOperations.rope(string), times);
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), repeated);
        }

        @Specialization(guards={"isRubyBignum(times)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject multiply(DynamicObject string, DynamicObject times) {
            throw new RaiseException(this.coreExceptions().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(times)", "!isInteger(times)"})
        public DynamicObject multiply(VirtualFrame frame, DynamicObject string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (ToIntNode)this.insert(ToIntNode.create());
            }
            return this.executeInt(frame, string, this.toIntNode.doInt(frame, times));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(context, sourceSection, null, null);
            this.makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
            this.taintResultNode = new TaintResultNode(null, null);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) == getEncoding(other)"})
        public DynamicObject addSameEncoding(DynamicObject string, DynamicObject other) {
            return this.add(string, other, this.getEncoding(string));
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) != getEncoding(other)", "isUTF8AndUSASCII(string, other)"})
        public DynamicObject addUTF8AndUSASCII(DynamicObject string, DynamicObject other) {
            return this.add(string, other, (Encoding)UTF8Encoding.INSTANCE);
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) != getEncoding(other)", "!isUTF8AndUSASCII(string, other)"})
        public DynamicObject addDifferentEncodings(DynamicObject string, DynamicObject other) {
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, other);
            return this.add(string, other, enc);
        }

        private DynamicObject add(DynamicObject string, DynamicObject other, Encoding encoding) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            Rope concatRope = this.makeConcatNode.executeMake(left, right, encoding);
            DynamicObject ret = Layouts.STRING.createString(this.coreLibrary().getStringFactory(), concatRope);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }

        protected Encoding getEncoding(DynamicObject string) {
            return Layouts.STRING.getRope(string).getEncoding();
        }

        protected boolean isUTF8AndUSASCII(DynamicObject string, DynamicObject other) {
            Encoding stringEncoding = this.getEncoding(string);
            Encoding otherEncoding = this.getEncoding(other);
            if (stringEncoding != UTF8Encoding.INSTANCE && otherEncoding != UTF8Encoding.INSTANCE) {
                return false;
            }
            return stringEncoding == USASCIIEncoding.INSTANCE || otherEncoding == USASCIIEncoding.INSTANCE;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, RopeConstants.EMPTY_ASCII_8BIT_ROPE);
        }
    }
}

