/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.rubinius.ByteArrayNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ByteArrayNodes.class)
public final class ByteArrayNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(GetByteNodeFactory.getInstance(), PrependNodeFactory.getInstance(), SetByteNodeFactory.getInstance(), SizeNodeFactory.getInstance(), LocateNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=ByteArrayNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(ByteArrayNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class}});
        }

        public ByteArrayNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ByteArrayNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=ByteArrayNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ByteArrayNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=ByteArrayNodes.LocateNode.class)
    public static final class LocateNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.LocateNode> {
        private static LocateNodeFactory locateNodeFactoryInstance;

        private LocateNodeFactory() {
            super(ByteArrayNodes.LocateNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ByteArrayNodes.LocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.LocateNode> getInstance() {
            if (locateNodeFactoryInstance == null) {
                locateNodeFactoryInstance = new LocateNodeFactory();
            }
            return locateNodeFactoryInstance;
        }

        public static ByteArrayNodes.LocateNode create(RubyNode[] arguments) {
            return new LocateNodeGen(arguments);
        }

        @GeneratedBy(value=ByteArrayNodes.LocateNode.class)
        public static final class LocateNodeGen
        extends ByteArrayNodes.LocateNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getByte(DynamicObject, DynamicObject, int, int)", value=ByteArrayNodes.LocateNode.class)
            private static final class GetByteNode_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;
                private final Class<?> arguments3ImplicitType;

                GetByteNode_(LocateNodeGen root, Object arguments2Value, Object arguments3Value) {
                    super(root, 1);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments3Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((GetByteNode_)other).arguments2ImplicitType && this.arguments3ImplicitType == ((GetByteNode_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments3Value_;
                    int arguments2Value_;
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.executeArguments3_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.executeArguments3_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        if (this.arguments3ImplicitType == Integer.TYPE) {
                            arguments3Value_ = this.root.arguments3_.executeInteger(frameValue);
                        } else {
                            Object arguments3Value__ = this.executeArguments3_((Frame)frameValue);
                            arguments3Value_ = RubyTypesGen.expectImplicitInteger(arguments3Value__, this.arguments3ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.getByte(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && RubyTypesGen.isImplicitInteger(arguments3Value, this.arguments3ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        int arguments3Value_ = RubyTypesGen.asImplicitInteger(arguments3Value, this.arguments3ImplicitType);
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.getByte(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(LocateNodeGen root, Object arguments2Value, Object arguments3Value) {
                    return new GetByteNode_(root, arguments2Value, arguments3Value);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.LocateNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocateNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(LocateNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.LocateNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocateNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(LocateNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.LocateNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocateNodeGen root;

                BaseNode_(LocateNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocateNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.executeArguments3_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value) && RubyTypesGen.isImplicitInteger(arguments3Value) && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return GetByteNode_.create(this.root, arguments2Value, arguments3Value);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Integer.TYPE) {
                        return this.root.arguments3_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ByteArrayNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(ByteArrayNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ByteArrayNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static ByteArrayNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=ByteArrayNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends ByteArrayNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ByteArrayNodes.SetByteNode.class)
    public static final class SetByteNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.SetByteNode> {
        private static SetByteNodeFactory setByteNodeFactoryInstance;

        private SetByteNodeFactory() {
            super(ByteArrayNodes.SetByteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ByteArrayNodes.SetByteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetByteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.SetByteNode> getInstance() {
            if (setByteNodeFactoryInstance == null) {
                setByteNodeFactoryInstance = new SetByteNodeFactory();
            }
            return setByteNodeFactoryInstance;
        }

        public static ByteArrayNodes.SetByteNode create(RubyNode[] arguments) {
            return new SetByteNodeGen(arguments);
        }

        @GeneratedBy(value=ByteArrayNodes.SetByteNode.class)
        public static final class SetByteNodeGen
        extends ByteArrayNodes.SetByteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetByteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="setByte(DynamicObject, int, int, BranchProfile)", value=ByteArrayNodes.SetByteNode.class)
            private static final class SetByteNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                SetByteNode_(SetByteNodeGen root, Object arguments1Value, Object arguments2Value, BranchProfile errorProfile) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.errorProfile = errorProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetByteNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetByteNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.setByte(arguments0Value_, arguments1Value_, arguments2Value_, this.errorProfile);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        return this.root.setByte(arguments0Value_, arguments1Value_, arguments2Value_, this.errorProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SetByteNodeGen root, Object arguments1Value, Object arguments2Value, BranchProfile errorProfile) {
                    return new SetByteNode_(root, arguments1Value, arguments2Value, errorProfile);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.SetByteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetByteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SetByteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.SetByteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetByteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SetByteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.SetByteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetByteNodeGen root;

                BaseNode_(SetByteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SetByteNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && RubyTypesGen.isImplicitInteger(arguments2Value)) {
                        BranchProfile errorProfile1 = BranchProfile.create();
                        return SetByteNode_.create(this.root, arguments1Value, arguments2Value, errorProfile1);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ByteArrayNodes.PrependNode.class)
    public static final class PrependNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.PrependNode> {
        private static PrependNodeFactory prependNodeFactoryInstance;

        private PrependNodeFactory() {
            super(ByteArrayNodes.PrependNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ByteArrayNodes.PrependNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PrependNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.PrependNode> getInstance() {
            if (prependNodeFactoryInstance == null) {
                prependNodeFactoryInstance = new PrependNodeFactory();
            }
            return prependNodeFactoryInstance;
        }

        public static ByteArrayNodes.PrependNode create(RubyNode[] arguments) {
            return new PrependNodeGen(arguments);
        }

        @GeneratedBy(value=ByteArrayNodes.PrependNode.class)
        public static final class PrependNodeGen
        extends ByteArrayNodes.PrependNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrependNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments1Value_)) {
                    return this.prepend(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ByteArrayNodes.GetByteNode.class)
    public static final class GetByteNodeFactory
    extends NodeFactoryBase<ByteArrayNodes.GetByteNode> {
        private static GetByteNodeFactory getByteNodeFactoryInstance;

        private GetByteNodeFactory() {
            super(ByteArrayNodes.GetByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ByteArrayNodes.GetByteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetByteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ByteArrayNodes.GetByteNode> getInstance() {
            if (getByteNodeFactoryInstance == null) {
                getByteNodeFactoryInstance = new GetByteNodeFactory();
            }
            return getByteNodeFactoryInstance;
        }

        public static ByteArrayNodes.GetByteNode create(RubyNode[] arguments) {
            return new GetByteNodeGen(arguments);
        }

        @GeneratedBy(value=ByteArrayNodes.GetByteNode.class)
        public static final class GetByteNodeGen
        extends ByteArrayNodes.GetByteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetByteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getByte(DynamicObject, int, ConditionProfile)", value=ByteArrayNodes.GetByteNode.class)
            private static final class GetByteNode_
            extends BaseNode_ {
                private final ConditionProfile nullByteIndexProfile;
                private final Class<?> arguments1ImplicitType;

                GetByteNode_(GetByteNodeGen root, Object arguments1Value, ConditionProfile nullByteIndexProfile) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.nullByteIndexProfile = nullByteIndexProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetByteNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.getByte(arguments0Value_, arguments1Value_, this.nullByteIndexProfile);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.getByte(arguments0Value_, arguments1Value_, this.nullByteIndexProfile);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root, Object arguments1Value, ConditionProfile nullByteIndexProfile) {
                    return new GetByteNode_(root, arguments1Value, nullByteIndexProfile);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.GetByteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetByteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.GetByteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetByteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ByteArrayNodes.GetByteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetByteNodeGen root;

                BaseNode_(GetByteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (GetByteNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        ConditionProfile nullByteIndexProfile1 = ConditionProfile.createBinaryProfile();
                        return GetByteNode_.create(this.root, arguments1Value, nullByteIndexProfile1);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }
}

