/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jcodings.transcode.EConv;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.encoding.EncodingConverterLayout;

@GeneratedBy(value=EncodingConverterLayout.class)
public class EncodingConverterLayoutImpl
extends BasicObjectLayoutImpl
implements EncodingConverterLayout {
    public static final EncodingConverterLayout INSTANCE = new EncodingConverterLayoutImpl();
    protected static final Shape.Allocator ENCODING_CONVERTER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ECONV_IDENTIFIER = new HiddenKey("econv");
    protected static final Property ECONV_PROPERTY = Property.create((Object)ECONV_IDENTIFIER, (Location)ENCODING_CONVERTER_ALLOCATOR.locationForType(EConv.class), (int)0);

    protected EncodingConverterLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createEncodingConverterShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new EncodingConverterType(logicalClass, metaClass)).addProperty(ECONV_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createEncodingConverter(DynamicObjectFactory factory, EConv econv) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (EncodingConverterLayoutImpl.createsEncodingConverter(factory));
        assert (factory.getShape().hasProperty((Object)ECONV_IDENTIFIER));
        return factory.newInstance(new Object[]{econv});
    }

    @Override
    public boolean isEncodingConverter(DynamicObject object) {
        return EncodingConverterLayoutImpl.isEncodingConverter(object.getShape().getObjectType());
    }

    private static boolean isEncodingConverter(ObjectType objectType) {
        return objectType instanceof EncodingConverterType;
    }

    private static boolean createsEncodingConverter(DynamicObjectFactory factory) {
        return EncodingConverterLayoutImpl.isEncodingConverter(factory.getShape().getObjectType());
    }

    @Override
    public EConv getEconv(DynamicObject object) {
        assert (this.isEncodingConverter(object));
        assert (object.getShape().hasProperty((Object)ECONV_IDENTIFIER));
        return (EConv)ECONV_PROPERTY.get(object, this.isEncodingConverter(object));
    }

    @Override
    public void setEconv(DynamicObject object, EConv value) {
        assert (this.isEncodingConverter(object));
        assert (object.getShape().hasProperty((Object)ECONV_IDENTIFIER));
        try {
            ECONV_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class EncodingConverterType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public EncodingConverterType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public EncodingConverterType setLogicalClass(DynamicObject logicalClass) {
            return new EncodingConverterType(logicalClass, this.metaClass);
        }

        @Override
        public EncodingConverterType setMetaClass(DynamicObject metaClass) {
            return new EncodingConverterType(this.logicalClass, metaClass);
        }
    }
}

