/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.dir;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.dir.DirLayout;

@GeneratedBy(value=DirLayout.class)
public class DirLayoutImpl
extends BasicObjectLayoutImpl
implements DirLayout {
    public static final DirLayout INSTANCE = new DirLayoutImpl();
    protected static final Shape.Allocator DIR_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey CONTENTS_IDENTIFIER = new HiddenKey("contents");
    protected static final Property CONTENTS_PROPERTY = Property.create((Object)CONTENTS_IDENTIFIER, (Location)DIR_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey POSITION_IDENTIFIER = new HiddenKey("position");
    protected static final Property POSITION_PROPERTY = Property.create((Object)POSITION_IDENTIFIER, (Location)DIR_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected DirLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createDirShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new DirType(logicalClass, metaClass)).addProperty(CONTENTS_PROPERTY).addProperty(POSITION_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createDir(DynamicObjectFactory factory, Object contents, int position) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (DirLayoutImpl.createsDir(factory));
        assert (factory.getShape().hasProperty((Object)CONTENTS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)POSITION_IDENTIFIER));
        return factory.newInstance(new Object[]{contents, position});
    }

    private static boolean isDir(DynamicObject object) {
        return DirLayoutImpl.isDir(object.getShape().getObjectType());
    }

    private static boolean isDir(ObjectType objectType) {
        return objectType instanceof DirType;
    }

    private static boolean createsDir(DynamicObjectFactory factory) {
        return DirLayoutImpl.isDir(factory.getShape().getObjectType());
    }

    @Override
    public Object getContents(DynamicObject object) {
        assert (DirLayoutImpl.isDir(object));
        assert (object.getShape().hasProperty((Object)CONTENTS_IDENTIFIER));
        return CONTENTS_PROPERTY.get(object, DirLayoutImpl.isDir(object));
    }

    @Override
    public void setContents(DynamicObject object, Object value) {
        assert (DirLayoutImpl.isDir(object));
        assert (object.getShape().hasProperty((Object)CONTENTS_IDENTIFIER));
        try {
            CONTENTS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getPosition(DynamicObject object) {
        assert (DirLayoutImpl.isDir(object));
        assert (object.getShape().hasProperty((Object)POSITION_IDENTIFIER));
        return (Integer)POSITION_PROPERTY.get(object, DirLayoutImpl.isDir(object));
    }

    @Override
    public void setPosition(DynamicObject object, int value) {
        assert (DirLayoutImpl.isDir(object));
        assert (object.getShape().hasProperty((Object)POSITION_IDENTIFIER));
        try {
            POSITION_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class DirType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public DirType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public DirType setLogicalClass(DynamicObject logicalClass) {
            return new DirType(logicalClass, this.metaClass);
        }

        @Override
        public DirType setMetaClass(DynamicObject metaClass) {
            return new DirType(this.logicalClass, metaClass);
        }
    }
}

