/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.cast.ToIntRangeNodeGen;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="range")
public abstract class ToIntRangeNode
extends RubyNode {
    @Node.Child
    private ToIntNode toIntNode;

    public static ToIntRangeNode create() {
        return ToIntRangeNodeGen.create(null);
    }

    public abstract DynamicObject executeToIntRange(VirtualFrame var1, DynamicObject var2);

    @Specialization(guards={"isIntRange(range)"})
    public DynamicObject intRange(DynamicObject range) {
        return range;
    }

    @Specialization(guards={"isLongRange(range)"})
    public DynamicObject longRange(VirtualFrame frame, DynamicObject range) {
        int begin = this.toInt(frame, Layouts.LONG_RANGE.getBegin(range));
        int end = this.toInt(frame, Layouts.LONG_RANGE.getEnd(range));
        boolean excludedEnd = Layouts.LONG_RANGE.getExcludedEnd(range);
        return Layouts.INT_RANGE.createIntRange(this.coreLibrary().getIntRangeFactory(), excludedEnd, begin, end);
    }

    @Specialization(guards={"isObjectRange(range)"})
    public DynamicObject objectRange(VirtualFrame frame, DynamicObject range) {
        int begin = this.toInt(frame, Layouts.OBJECT_RANGE.getBegin(range));
        int end = this.toInt(frame, Layouts.OBJECT_RANGE.getEnd(range));
        boolean excludedEnd = Layouts.OBJECT_RANGE.getExcludedEnd(range);
        return Layouts.INT_RANGE.createIntRange(this.coreLibrary().getIntRangeFactory(), excludedEnd, begin, end);
    }

    private int toInt(VirtualFrame frame, Object indexObject) {
        if (this.toIntNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntNode = (ToIntNode)this.insert(ToIntNode.create());
        }
        return this.toIntNode.doInt(frame, indexObject);
    }
}

